/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.execute.render.export;

import com.lowagie.text.pdf.FontMapper;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.StringUtils;
import kd.bos.print.core.ExecuteContext;
import kd.bos.print.core.ExecuteService;
import kd.bos.print.core.ctrl.common.util.FileUtil;
import kd.bos.print.core.ctrl.print.io.PrintFontMapper;
import kd.bos.print.core.execute.render.export.MemFileOutputStream;
import kd.bos.print.core.execute.render.painter.APaperPainter;
import kd.bos.print.core.execute.render.painter.BasePainter;
import kd.bos.print.core.execute.render.painter.share.ShareResource;
import kd.bos.print.core.plugin.PrintPluginProxy;
import kd.bos.print.core.plugin.event.ExpFileEvent;
import kd.bos.print.core.service.PrtAttach;

public abstract class AbstractPrtExport<P extends APaperPainter> {
    protected OutputStream os;
    protected int curExpPageSize = 0;
    protected int curFileIndex;
    protected List<PrtAttach.AttachDetail> attachList = new ArrayList<PrtAttach.AttachDetail>();
    protected ShareResource share;
    protected String fileName;
    public FontMapper DEFAULT_FONTMAPPER = PrintFontMapper.createInstance();
    protected final Log log = LogFactory.getLog(this.getClass());

    public void begin(P paper) {
        if (this.share == null) {
            this.share = ((BasePainter)paper).getPaintContext().getShareResource();
        }
        this.curFileIndex = ((APaperPainter)paper).getFileIndex();
        this.fileName = ((APaperPainter)paper).getFileName();
        this.os = this.createOs();
    }

    public abstract void export(P var1);

    protected OutputStream createOs() {
        String path = File.separator + "temp" + File.separator + ExecuteContext.get().getTaskId();
        FileUtil.createFolder(path);
        path = path + File.separator + this.curFileIndex + "." + this.getFileNameSuffix();
        return new MemFileOutputStream(path);
    }

    public abstract void endOne() throws Exception;

    protected abstract String getFileNameSuffix();

    protected String getFileName() {
        String suffix = "." + this.getFileNameSuffix();
        String fileName = this.share.getFileName();
        if (ExecuteContext.get().isFileCreateBySingleBill() && !StringUtils.isEmpty((Object)this.fileName)) {
            fileName = this.fileName;
        }
        fileName = this.curFileIndex == 1 ? fileName + suffix : fileName + "-" + (this.curFileIndex - 1) + suffix;
        PrintPluginProxy pluginProxy = ExecuteContext.get().getPluginProxy();
        if (pluginProxy != null) {
            ExpFileEvent evt = new ExpFileEvent(fileName, this.curFileIndex);
            pluginProxy.fireBeforeExpFile(evt);
            fileName = evt.getFileName();
            if (!fileName.toLowerCase(Locale.ENGLISH).endsWith(suffix)) {
                fileName = fileName + suffix;
            }
        }
        return fileName;
    }

    public void end() throws Exception {
        this.endOne();
        if (this.share != null) {
            this.share.addAttachList(this.attachList, this.curExpPageSize);
        } else {
            this.log.error("share\u4e3a\u7a7a\u3002attachList.size()={},curPdfPageSize={}", (Object)this.attachList.size(), (Object)this.curExpPageSize);
        }
        this.log.debug(String.format("\u7ebf\u7a0b%s\u6267\u884c\u5b8c\u6bd5:%s", Thread.currentThread().getName(), System.currentTimeMillis()));
    }

    protected String savePrtFile(String saveFileName, OutputStream outputStream) throws Exception {
        if (outputStream instanceof MemFileOutputStream) {
            return ((MemFileOutputStream)this.os).save2Attach(saveFileName);
        }
        return ExecuteService.getAttachService().savePrtFile(saveFileName, ((ByteArrayOutputStream)outputStream).toByteArray());
    }
}

