/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.execute.render.export;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import kd.bos.print.core.ExecuteContext;
import kd.bos.print.core.ctrl.common.util.FileUtil;
import kd.bos.print.core.exception.PrintException;
import kd.bos.print.core.execute.render.export.AbstractPdfExport;
import kd.bos.print.core.execute.render.painter.pwpainer.PaperPainter;
import kd.bos.print.core.service.PrtAttach;

public class DiskPdfExport
extends AbstractPdfExport<PaperPainter> {
    private String path = null;

    @Override
    protected OutputStream createOs() {
        this.path = File.separator + "temp" + File.separator + ExecuteContext.get().getTaskId();
        try {
            FileUtil.createFolder(this.path);
            this.path = this.path + File.separator + this.curFileIndex + ".pdf";
            return new FileOutputStream(this.path);
        }
        catch (FileNotFoundException e) {
            throw new PrintException("-1", e);
        }
    }

    @Override
    public void export(PaperPainter painter) {
        super.export(painter);
    }

    @Override
    public void endOne() throws Exception {
        if (this.document == null) {
            return;
        }
        String fileName = this.getFileName();
        this.document.addTitle(fileName);
        this.document.close();
        this.os.flush();
        PrtAttach.AttachDetail attachDetail = new PrtAttach.AttachDetail();
        attachDetail.setFileName(fileName);
        attachDetail.setSource("B");
        attachDetail.setSeq(this.curFileIndex);
        attachDetail.setFilePath(this.path);
        this.attachList.add(attachDetail);
        this.os.close();
        this.document = null;
    }

    @Override
    public void end() throws Exception {
        super.end();
    }
}

