/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.execute.render.export;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import javax.imageio.ImageIO;
import kd.bos.form.watermark.WaterMark;
import kd.bos.print.core.ctrl.print.io.ImageWatermarkDrawer;
import kd.bos.print.core.ctrl.print.util.KPrintUtil;
import kd.bos.print.core.ctrl.reportone.r1.print.common.R1PrintInfo;
import kd.bos.print.core.exception.PrintException;
import kd.bos.print.core.execute.render.export.AbstractPrtExport;
import kd.bos.print.core.execute.render.painter.PaintPaperInfo;
import kd.bos.print.core.execute.render.painter.pwpainer.image.ImagePaperPainter;
import kd.bos.print.core.service.PrtAttach;

public class ImagePrtExport
extends AbstractPrtExport<ImagePaperPainter> {
    protected BufferedImage image;
    private Graphics2D graphic;
    protected int drawHeight = 0;
    private WaterMark waterMark;
    private final ImageWatermarkDrawer imageWaterDrawer = new ImageWatermarkDrawer();

    @Override
    public void begin(ImagePaperPainter paper) {
        super.begin(paper);
        PaintPaperInfo printInfo = paper.getPaperInfo();
        this.waterMark = printInfo.getWaterMark();
    }

    @Override
    public void export(ImagePaperPainter painter) {
        PaintPaperInfo paperInfo = painter.getPaperInfo();
        R1PrintInfo r1PrintInfo = paperInfo.getR1PrintInfo();
        int width = r1PrintInfo.getPaperSize().width;
        int height = r1PrintInfo.getPaperSize().height;
        int widthLom = (int)KPrintUtil.lomToPrintPoint(width);
        int heightLom = (int)KPrintUtil.lomToPrintPoint(height);
        if (this.os == null) {
            this.begin(painter);
            int maxHeight = heightLom * 20;
            this.image = new BufferedImage(widthLom, maxHeight, 1);
            this.graphic = this.image.createGraphics();
            this.graphic.setClip(0, 0, width, maxHeight);
            this.graphic.setColor(Color.white);
            this.graphic.fillRect(0, 0, width, maxHeight);
        }
        this.drawHeight += heightLom;
        painter.paint(this.graphic);
        if (this.waterMark != null) {
            Graphics2D graphics = (Graphics2D)this.graphic.create();
            graphics.translate(0, 0);
            this.imageWaterDrawer.addWaterMark(graphics, widthLom, heightLom, this.waterMark);
            graphics.dispose();
        }
        this.graphic.translate(0.0, KPrintUtil.lomToPrintPoint(height));
    }

    @Override
    public void endOne() throws Exception {
        if (this.os == null) {
            return;
        }
        this.graphic.dispose();
        try {
            BufferedImage subimage = this.image.getSubimage(0, 0, this.image.getWidth(), this.drawHeight);
            ImageIO.write((RenderedImage)subimage, this.getFileNameSuffix(), this.os);
        }
        catch (IOException e) {
            this.log.error((Throwable)e);
            throw new PrintException("-1", "Print page write to Image Error\u3002");
        }
        this.os.flush();
        this.attachProcess();
        this.os.close();
        this.os = null;
        this.image = null;
        this.graphic = null;
        this.drawHeight = 0;
    }

    protected void attachProcess() throws Exception {
        String fileName = this.getFileName();
        PrtAttach.AttachDetail attachDetail = new PrtAttach.AttachDetail();
        attachDetail.setFileName(fileName);
        attachDetail.setSource("B");
        attachDetail.setSeq(this.curFileIndex);
        String filePath = this.savePrtFile(attachDetail.getFileName(), this.os);
        attachDetail.setFilePath(filePath);
        this.attachList.add(attachDetail);
    }

    @Override
    protected String getFileNameSuffix() {
        return "png";
    }
}

