/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.execute.render.export;

import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.print.core.ExecuteService;
import kd.bos.print.core.ctrl.common.util.FileUtil;

public class MemFileOutputStream
extends OutputStream {
    private long length;
    private ByteArrayOutputStream byteOs;
    private FileOutputStream fileOs;
    private OutputStream currentOs;
    private static final long MAX_MEM_SIZE = 0x6400000L;
    private String filePath;
    private Log log = LogFactory.getLog(MemFileOutputStream.class);

    public MemFileOutputStream(String filePath) {
        this.filePath = filePath;
        this.byteOs = new ByteArrayOutputStream();
        this.currentOs = this.byteOs;
    }

    @Override
    public void write(int b) throws IOException {
        this.currentOs.write(b);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.beforeWrite(b);
        this.currentOs.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.beforeWrite(b);
        this.currentOs.write(b, off, len);
    }

    @Override
    public void flush() throws IOException {
        this.currentOs.flush();
    }

    @Override
    public void close() throws IOException {
        if (this.byteOs != null) {
            this.byteOs.close();
        }
        if (this.fileOs != null) {
            this.fileOs.close();
        }
        if (this.currentOs != null) {
            this.currentOs.close();
        }
    }

    private void beforeWrite(byte[] b) throws IOException {
        this.length += (long)b.length;
        if (this.currentOs instanceof ByteArrayOutputStream && this.length > 0x6400000L) {
            this.log.info("\u6587\u4ef6\u8d85\u8fc7{} byte,\u6539\u7528\u78c1\u76d8\u6d41", (Object)0x6400000L);
            this.fileOs = new FileOutputStream(this.filePath);
            this.fileOs.write(this.byteOs.toByteArray());
            this.currentOs = this.fileOs;
            if (this.byteOs != null) {
                this.byteOs.close();
                this.byteOs = null;
            }
        }
    }

    /*
     * Loose catch block
     */
    public String save2Attach(String saveFileName) throws Exception {
        if (this.currentOs instanceof ByteArrayOutputStream) {
            String filePath = ExecuteService.getAttachService().savePrtFile(saveFileName, ((ByteArrayOutputStream)this.currentOs).toByteArray());
            return filePath;
        }
        try {
            try (FileInputStream inputStream = new FileInputStream(this.filePath);){
                String filePath;
                String string = filePath = ExecuteService.getAttachService().savePrtFile(saveFileName, inputStream);
                return string;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            FileUtil.deleteFile(this.filePath);
        }
    }
}

