/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.execute.render.export;

import java.math.BigDecimal;
import java.math.RoundingMode;
import kd.bos.print.core.ExecuteContext;
import kd.bos.print.core.ExecuteService;
import kd.bos.print.core.execute.render.export.ImagePrtExport;
import kd.bos.print.core.service.PrtAttach;

public class SingleImagePrtExport
extends ImagePrtExport {
    @Override
    protected void attachProcess() throws Exception {
        String taskId = ExecuteContext.get().getTaskId();
        String attachId = taskId + this.curFileIndex;
        PrtAttach attach = new PrtAttach();
        attach.setTaskId(attachId);
        attach.setOrgId(ExecuteService.getUserService().getOrgId());
        attach.setAppId(ExecuteContext.get().getAppId());
        attach.setUserId(ExecuteService.getUserId());
        attach.setFormId(ExecuteContext.get().getFormId());
        attach.setDiskType(ExecuteContext.get().getpFileStorageType().getCode());
        PrtAttach.AttachDetail attachDetail = new PrtAttach.AttachDetail();
        attachDetail.setAttachId(attachId);
        attachDetail.setFileName(this.getFileName());
        attachDetail.setSource("B");
        attachDetail.setSeq(this.curFileIndex);
        Double ratioDouble = this.getRatioDouble(new BigDecimal(this.image.getWidth()), new BigDecimal(this.drawHeight));
        attachDetail.setExtParam(String.valueOf(ratioDouble));
        attachDetail.setFilePath(this.savePrtFile(attachDetail.getFileName(), this.os));
        attach.addAttachDetail(attachDetail);
        this.attachList.add(attachDetail);
        ExecuteContext.get().setPreview(true);
        ExecuteContext.get().getServiceProxy().getAttachmentService().savePrtResult(attach);
        ExecuteContext.get().setPreview(false);
    }

    private Double getRatioDouble(BigDecimal width, BigDecimal height) {
        BigDecimal ratio = BigDecimal.valueOf(0.0);
        if (height.doubleValue() != 0.0) {
            ratio = width.divide(height, 4, RoundingMode.HALF_UP);
        }
        return ratio.doubleValue();
    }
}

