/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.execute.render.painter;

import java.util.HashMap;
import java.util.Map;
import kd.bos.print.core.data.field.Field;
import kd.bos.print.core.data.field.MapField;
import kd.bos.print.core.execute.render.painter.IPainter;
import kd.bos.print.core.execute.render.painter.pwpainer.LinePainter;
import kd.bos.print.core.execute.render.painter.pwpainer.PicturePainter;
import kd.bos.print.core.execute.render.painter.pwpainer.QRCodePainter;
import kd.bos.print.core.execute.render.painter.pwpainer.RichTextPainter;
import kd.bos.print.core.execute.render.painter.pwpainer.view.ViewWidgetPainter;
import kd.bos.print.core.model.ui.view.LabelCellViewPainter;
import kd.bos.print.core.model.widget.AbstractPrintWidget;
import kd.bos.print.core.model.widget.PWLine;
import kd.bos.print.core.model.widget.PWPicture;
import kd.bos.print.core.model.widget.PWRichText;
import kd.bos.print.core.model.widget.barcode.PWBarcode;
import kd.bos.util.ThreadLocals;

public class PainterFactory {
    private static final String OLD_PAINTER = "oldPainter";
    private static ThreadLocal<PainterFactory> current = ThreadLocals.create();
    private Map<String, IPainter> painterMap = new HashMap<String, IPainter>();

    private static void set(PainterFactory rc) {
        current.set(rc);
    }

    public static PainterFactory get() {
        PainterFactory factory = current.get();
        if (factory == null) {
            PainterFactory.set(new PainterFactory());
        }
        return current.get();
    }

    public IPainter getPainter(AbstractPrintWidget widget) {
        String painterKey = this.getPainterKey(widget);
        return this.getPainter(painterKey);
    }

    public IPainter getViewPainter() {
        return this.getPainter(OLD_PAINTER);
    }

    private IPainter getPainter(String painterKey) {
        IPainter painter = this.painterMap.get(painterKey);
        if (painter == null) {
            painter = "QRCodePainter".equals(painterKey) ? new QRCodePainter() : ("PicturePainter".equals(painterKey) ? new PicturePainter() : ("PWRichText".equals(painterKey) ? new RichTextPainter() : ("PWLine".equals(painterKey) ? new LinePainter() : new ViewWidgetPainter())));
            this.painterMap.put(painterKey, painter);
        }
        return painter;
    }

    public void release() {
        LabelCellViewPainter.release();
    }

    private String getPainterKey(AbstractPrintWidget widget) {
        if (widget instanceof PWBarcode) {
            MapField mapField;
            Map value;
            String type;
            Field outputValue = widget.getOutputValue();
            if (outputValue instanceof MapField && "QR_CODE".equals(type = (String)(value = (Map)(mapField = (MapField)outputValue).getValue()).get("barcodeType"))) {
                return QRCodePainter.class.getSimpleName();
            }
            return OLD_PAINTER;
        }
        if (widget instanceof PWPicture) {
            return PicturePainter.class.getSimpleName();
        }
        if (widget instanceof PWRichText) {
            return PWRichText.class.getSimpleName();
        }
        if (widget instanceof PWLine) {
            return PWLine.class.getSimpleName();
        }
        return OLD_PAINTER;
    }
}

