/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.execute.render.painter.pwpainer;

import com.lowagie.text.DocumentException;
import com.lowagie.text.Image;
import com.lowagie.text.pdf.PdfTemplate;
import java.awt.Dimension;
import java.awt.Graphics;
import kd.bos.print.core.ExecuteContext;
import kd.bos.print.core.ctrl.kdf.util.style.StyleUtil;
import kd.bos.print.core.ctrl.reportone.r1.print.common.R1PrintInfo;
import kd.bos.print.core.execute.render.painter.BasePWPainter;
import kd.bos.print.core.model.widget.AbstractPrintWidget;
import kd.bos.print.core.plugin.PrintPluginProxy;
import kd.bos.print.core.unitest.PrintUntiTestPluginProxy;

public class BaseImagePainter<T extends AbstractPrintWidget>
extends BasePWPainter<T> {
    @Override
    public void paint(Graphics g) {
        this.paint(g, this.context.getPdftemplate());
    }

    protected void addImage(PdfTemplate pdfTemplate, Image image, float widthLom, float heightLom, float xLom, float yLom) {
        R1PrintInfo r1PrintInfo = this.paperInfo.getR1PrintInfo();
        int marginLeft = r1PrintInfo.getMarginLeft();
        int marginTop = r1PrintInfo.getMarginTop();
        yLom = (float)marginTop + yLom + heightLom;
        Dimension paperSize = this.paperInfo.getR1PrintInfo().getPaperSize();
        int paperHeight = paperSize.height;
        try {
            float width = (float)StyleUtil.lomToPt(widthLom);
            float height = (float)StyleUtil.lomToPt(heightLom);
            float x = (float)StyleUtil.lomToPt((float)marginLeft + xLom);
            float y = (float)StyleUtil.lomToPt((float)paperHeight - yLom);
            pdfTemplate.addImage(image, width, 0.0f, 0.0f, height, x, y);
            PrintPluginProxy pluginProxy = ExecuteContext.get().getPluginProxy();
            if (pluginProxy != null) {
                pluginProxy.fireUnitestPlugin(PrintUntiTestPluginProxy.Method.BeforePaintImg, this.getPaintObj(), image, Float.valueOf(width), Float.valueOf(height), Float.valueOf(x), Float.valueOf(y));
            }
        }
        catch (DocumentException e) {
            this.log.warn("\u6dfb\u52a0\u56fe\u7247\u5931\u8d25\uff1a", (Throwable)e);
        }
    }

    @Deprecated
    protected void addImage(Image image, float widthLom, float heightLom, float xLom, float yLom) {
        this.addImage(this.context.getPdftemplate(), image, widthLom, heightLom, xLom, yLom);
    }

    protected void addImageOri(PdfTemplate pdfTemplate, Image image, float widthLom, float heightLom, float xLom, float yLom) {
        R1PrintInfo r1PrintInfo = this.paperInfo.getR1PrintInfo();
        int marginLeft = r1PrintInfo.getMarginLeft();
        int marginTop = r1PrintInfo.getMarginTop();
        yLom = (float)marginTop + yLom + heightLom;
        Dimension paperSize = this.paperInfo.getR1PrintInfo().getPaperSize();
        int paperHeight = paperSize.height;
        try {
            float imageWidthPt = this.pixelToPt(image.getWidth());
            float imageHeightPt = this.pixelToPt(image.getHeight());
            float widthLomPt = (float)StyleUtil.lomToPt(widthLom);
            float heightLomPt = (float)StyleUtil.lomToPt(heightLom);
            PdfTemplate template = pdfTemplate.createTemplate(widthLomPt, heightLomPt);
            template.addImage(image, imageWidthPt, 0.0f, 0.0f, imageHeightPt, 0.0f, heightLomPt - imageHeightPt);
            this.context.getPdftemplate().addTemplate(template, (float)StyleUtil.lomToPt((float)marginLeft + xLom), (float)StyleUtil.lomToPt((float)paperHeight - yLom));
        }
        catch (DocumentException e) {
            this.log.warn("\u6dfb\u52a0\u56fe\u7247\u5931\u8d25\uff1a", (Throwable)e);
        }
    }

    @Deprecated
    protected void addImageOri(Image image, float widthLom, float heightLom, float xLom, float yLom) {
        this.addImageOri(this.context.getPdftemplate(), image, widthLom, heightLom, xLom, yLom);
    }
}

