/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.execute.render.painter.pwpainer;

import java.awt.BasicStroke;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Stroke;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.print.core.ctrl.kdf.util.style.PenStyle;
import kd.bos.print.core.ctrl.kdf.util.style.Style;
import kd.bos.print.core.ctrl.kdf.util.style.StyleUtil;
import kd.bos.print.core.ctrl.kdf.util.style.Styles;
import kd.bos.print.core.execute.render.painter.BasePWPainter;
import kd.bos.print.core.model.widget.PWLine;

public class LinePainter
extends BasePWPainter<PWLine> {
    private static Log logger = LogFactory.getLog(LinePainter.class);

    @Override
    public void paint(Graphics g) {
        PWLine line = (PWLine)this.getPaintObj();
        LinePainter.linePainter((Graphics2D)g, line);
    }

    private static void linePainter(Graphics2D g, PWLine line) {
        Rectangle rectangle = line.getRectangle();
        Graphics2D g2d = g;
        int width = (int)StyleUtil.lomToPixel(rectangle.getWidth());
        int height = (int)StyleUtil.lomToPixel(rectangle.getHeight());
        int x = (int)StyleUtil.lomToPixel(rectangle.getX());
        int y = (int)StyleUtil.lomToPixel(rectangle.getY());
        LinePainter.linePainter(line, g2d, x, y, width, height);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void linePainter(PWLine line, Graphics2D g2d, int x, int y, int width, int height) {
        Stroke preStroke = g2d.getStroke();
        try {
            Style style = line.getStyle();
            if ("H".equals(line.getDirection())) {
                LinePainter.setStroke(g2d, style, height);
                g2d.drawLine(x, y + height / 2, x + width, y + height / 2);
            } else {
                LinePainter.setStroke(g2d, style, width);
                g2d.drawLine(x + width / 2, y, x + width / 2, y + height);
            }
        }
        catch (Exception e) {
            logger.error("add line error\uff1a", (Throwable)e);
        }
        finally {
            g2d.setStroke(preStroke);
        }
    }

    private static void setStroke(Graphics2D g2d, Style style, int lineWidth) {
        PenStyle penStyle = style.getBorderPenStyle(Styles.Position.BOTTOM);
        float[] dashPattern = new float[]{1.0f, 0.0f};
        if (PenStyle.PS_DOT.getName().equals(penStyle.getName())) {
            dashPattern = new float[]{2.0f, 2.0f};
        } else if (PenStyle.PS_DASH.getName().equals(penStyle.getName())) {
            dashPattern = new float[]{3.0f, 1.0f};
        }
        g2d.setStroke(new BasicStroke(lineWidth, 0, 0, 10.0f, dashPattern, 0.0f));
        g2d.setColor(style.getBorderColor(Styles.Position.BOTTOM));
    }
}

