/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.execute.render.painter.pwpainer;

import com.lowagie.text.DocumentException;
import com.lowagie.text.Image;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.List;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.print.core.ExecuteContext;
import kd.bos.print.core.ctrl.kdf.util.style.StyleUtil;
import kd.bos.print.core.ctrl.reportone.r1.print.common.R1PrintInfo;
import kd.bos.print.core.execute.render.painter.APaperPainter;
import kd.bos.print.core.execute.render.painter.IPainter;
import kd.bos.print.core.execute.render.painter.PaintPaperInfo;
import kd.bos.print.core.execute.render.painter.PainterFactory;
import kd.bos.print.core.execute.render.painter.share.PdfImageShare;
import kd.bos.print.core.model.widget.AbstractPrintWidget;
import kd.bos.print.core.model.widget.PWPage;
import kd.bos.print.core.plugin.PrintPluginProxy;
import kd.bos.print.core.unitest.PrintUntiTestPluginProxy;

public class PaperPainter
extends APaperPainter<PWPage> {
    private Log log = LogFactory.getLog(this.getClass());

    public PaperPainter(PaintPaperInfo paperInfo) {
        this.setPaperInfo(paperInfo);
    }

    @Override
    public void paint(Graphics g) {
        this.paintBackGround(g);
        this.paintPage(g);
    }

    protected void paintPage(Graphics g) {
        R1PrintInfo r1PrintInfo = this.paperInfo.getR1PrintInfo();
        int marginLeft = r1PrintInfo.getMarginLeft();
        int marginTop = r1PrintInfo.getMarginTop();
        PWPage pwPage = (PWPage)this.getPaintObj();
        List children = pwPage.getChildren();
        for (AbstractPrintWidget widget : children) {
            Graphics2D g2d = (Graphics2D)g.create();
            g2d.translate(this.lomToPixel(marginLeft), this.lomToPixel(marginTop));
            IPainter painter = this.getPainter(widget);
            painter.addPaintObj(widget);
            painter.setPaintContext(this.getPaintContext());
            painter.setPaperInfo(this.getPaperInfo());
            painter.paint(g2d);
            g2d.dispose();
        }
    }

    protected IPainter getPainter(AbstractPrintWidget widget) {
        IPainter painter = PainterFactory.get().getPainter(widget);
        return painter;
    }

    protected void paintBackGround(Graphics g) {
        R1PrintInfo r1PrintInfo = this.getPaperInfo().getR1PrintInfo();
        if (!r1PrintInfo.isShowBgImage()) {
            return;
        }
        String bgImageUrl = r1PrintInfo.getBgImageUrl();
        if (StringUtils.isBlank((CharSequence)bgImageUrl)) {
            return;
        }
        PdfImageShare imageShare = (PdfImageShare)this.context.getShareResource().getImageShare();
        Image image = (Image)imageShare.getOrGenImage(bgImageUrl);
        if (image == null) {
            return;
        }
        Dimension paperSize = r1PrintInfo.getPaperSize();
        float imageWidth = image.getWidth();
        float imageHeight = image.getHeight();
        float imageWidthLom = StyleUtil.pixelToLom((long)imageWidth);
        float imageHeightLom = StyleUtil.pixelToLom((long)imageHeight);
        float xRate = imageWidthLom / (float)paperSize.width;
        if (xRate <= 1.0f) {
            xRate = 1.0f;
        }
        this.addImage(image, imageWidthLom /= xRate, imageHeightLom /= xRate, 0.0f, 0.0f);
    }

    protected void addImage(Image image, float widthLom, float heightLom, float xLom, float yLom) {
        R1PrintInfo r1PrintInfo = this.paperInfo.getR1PrintInfo();
        yLom += heightLom;
        Dimension paperSize = this.paperInfo.getR1PrintInfo().getPaperSize();
        int paperHeight = paperSize.height;
        try {
            float width = (float)StyleUtil.lomToPt(widthLom);
            float height = (float)StyleUtil.lomToPt(heightLom);
            float x = (float)StyleUtil.lomToPt(xLom);
            float y = (float)StyleUtil.lomToPt((float)paperHeight - yLom);
            this.context.getPdftemplate().addImage(image, width, 0.0f, 0.0f, height, x, y);
            PrintPluginProxy pluginProxy = ExecuteContext.get().getPluginProxy();
            if (pluginProxy != null) {
                pluginProxy.fireUnitestPlugin(PrintUntiTestPluginProxy.Method.BeforePaintImg, this.getPaintObj(), image, Float.valueOf(width), Float.valueOf(height), Float.valueOf(x), Float.valueOf(y));
            }
        }
        catch (DocumentException e) {
            this.log.warn("\u6dfb\u52a0\u56fe\u7247\u5931\u8d25\uff1a", (Throwable)e);
        }
    }

    @Override
    public int getPageIndex() {
        return ((PWPage)this.getPaintObj()).getPageIndex();
    }

    @Override
    public String getTplKey() {
        return ((PWPage)this.getPaintObj()).getKey();
    }

    @Override
    public String getTplName() {
        return super.getTplName();
    }
}

