/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.execute.render.painter.pwpainer;

import com.lowagie.text.Image;
import com.lowagie.text.pdf.PdfTemplate;
import java.awt.Graphics;
import java.awt.Rectangle;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.print.core.ctrl.kdf.util.style.Rect;
import kd.bos.print.core.ctrl.kdf.util.style.Style;
import kd.bos.print.core.ctrl.kdf.util.style.Styles;
import kd.bos.print.core.data.field.Field;
import kd.bos.print.core.data.field.ImageField;
import kd.bos.print.core.data.field.TextField;
import kd.bos.print.core.execute.render.painter.pwpainer.BaseImagePainter;
import kd.bos.print.core.model.ui.view.StyleRender;
import kd.bos.print.core.model.widget.PWPicture;

public class PicturePainter
extends BaseImagePainter<PWPicture> {
    @Override
    public void paint(Graphics g, PdfTemplate pdfTemplate) {
        int scaleType;
        PWPicture paintObj = (PWPicture)this.getPaintObj();
        Field field = paintObj.getOutputValue();
        if (!(field instanceof ImageField) && field instanceof TextField) {
            field = new ImageField((String)((TextField)field).getValue());
        }
        if (!(field instanceof ImageField)) {
            return;
        }
        ImageField outputValue = (ImageField)field;
        String imageKey = (String)outputValue.getValue();
        if (StringUtils.isBlank((CharSequence)imageKey)) {
            return;
        }
        Image image = (Image)this.context.getShareResource().getImageShare().getOrGenImage(imageKey);
        if (image == null) {
            if (outputValue.getImageByte() == null) {
                return;
            }
            try {
                image = Image.getInstance((byte[])outputValue.getImageByte());
            }
            catch (Exception e) {
                this.log.error((Throwable)e);
                return;
            }
        }
        if ((scaleType = paintObj.getScaleType()) == 0) {
            this.drawImageOri(pdfTemplate, paintObj, image);
        } else {
            this.drawImageScale(pdfTemplate, paintObj, image);
        }
        this.drawBorder(g, paintObj);
    }

    private void drawImageOri(PdfTemplate pdfTemplate, PWPicture paintObj, Image image) {
        Rectangle rectangle = paintObj.getRectangle();
        Style style = paintObj.getStyle();
        Rect padding = style.getPadding();
        Rectangle imageRectangle = rectangle;
        if (padding != null) {
            imageRectangle = new Rectangle((int)(rectangle.getX() + (double)padding.getLeft()), (int)(rectangle.getY() + (double)padding.getTop()), (int)(rectangle.getWidth() - (double)(padding.getLeft() + padding.getRight())), (int)(rectangle.getHeight() - (double)(padding.getTop() + padding.getBottom())));
        }
        float move = 0.0f;
        if (!style.getBorder(Styles.Position.LEFT).isNull()) {
            int width = style.getBorderLineStyle(Styles.Position.LEFT).getWidth();
            move = this.pixelToLom(width) + 1.0f;
        }
        float xMove = move / 2.0f;
        float yMove = move;
        float imageWidth = this.pixelToLom(image.getWidth());
        float imageHeight = this.pixelToLom(image.getHeight());
        double rHeight = imageRectangle.getHeight();
        double rWidth = imageRectangle.getWidth();
        if (rHeight - (double)imageHeight > 0.0) {
            if (Styles.VerticalAlignment.MIDDLE.equals(style.getVerticalAlign()) && imageHeight < (float)imageRectangle.height) {
                yMove = ((float)imageRectangle.height - imageHeight) / 2.0f;
            }
            if (Styles.VerticalAlignment.BOTTOM.equals(style.getVerticalAlign()) && imageHeight < (float)imageRectangle.height) {
                yMove = (float)imageRectangle.height - imageHeight - move;
            }
        }
        if (rWidth - (double)imageWidth > 0.0) {
            if (Styles.HorizontalAlignment.CENTER.equals(style.getHorizontalAlign()) && imageWidth < (float)imageRectangle.width) {
                xMove = ((float)imageRectangle.width - imageWidth) / 2.0f;
            }
            if (Styles.HorizontalAlignment.RIGHT.equals(style.getHorizontalAlign()) && imageWidth < (float)imageRectangle.width) {
                xMove = (float)imageRectangle.width - imageWidth - move * 3.0f / 2.0f;
            }
        }
        this.addImageOri(pdfTemplate, image, (float)imageRectangle.width - move * 2.0f, (float)imageRectangle.height - move * 2.0f, (float)imageRectangle.x + xMove, (float)imageRectangle.y + yMove);
    }

    private void drawImageScale(PdfTemplate pdfTemplate, PWPicture paintObj, Image image) {
        float imageHeight;
        float yRate;
        float imageWidth;
        float xRate;
        float rate;
        Rectangle rectangle = paintObj.getRectangle();
        Style style = paintObj.getStyle();
        Rect padding = style.getPadding();
        Rectangle imageRectangle = rectangle;
        if (padding != null) {
            imageRectangle = new Rectangle((int)(rectangle.getX() + (double)padding.getLeft()), (int)(rectangle.getY() + (double)padding.getTop()), (int)(rectangle.getWidth() - (double)(padding.getLeft() + padding.getRight())), (int)(rectangle.getHeight() - (double)(padding.getTop() + padding.getBottom())));
        }
        float f = rate = (xRate = (imageWidth = image.getWidth()) / (float)imageRectangle.width) > (yRate = (imageHeight = image.getHeight()) / (float)imageRectangle.height) ? xRate : yRate;
        if (rate == xRate) {
            imageWidth = imageRectangle.width;
            imageHeight /= rate;
        } else {
            imageWidth /= rate;
            imageHeight = imageRectangle.height;
        }
        float move = 0.0f;
        if (!style.getBorder(Styles.Position.LEFT).isNull()) {
            int width = style.getBorderLineStyle(Styles.Position.LEFT).getWidth();
            move = this.pixelToLom(width) + 1.0f;
            imageWidth -= move * 2.0f;
            imageHeight -= move * 2.0f;
        }
        float xMove = move / 2.0f;
        float yMove = move;
        if (rate == xRate) {
            if (Styles.VerticalAlignment.MIDDLE.equals(style.getVerticalAlign()) && imageHeight < (float)imageRectangle.height) {
                yMove = ((float)imageRectangle.height - imageHeight) / 2.0f;
            }
            if (Styles.VerticalAlignment.BOTTOM.equals(style.getVerticalAlign()) && imageHeight < (float)imageRectangle.height) {
                yMove = (float)imageRectangle.height - imageHeight - move;
            }
        } else {
            if (Styles.HorizontalAlignment.CENTER.equals(style.getHorizontalAlign()) && imageWidth < (float)imageRectangle.width) {
                xMove = ((float)imageRectangle.width - imageWidth) / 2.0f;
            }
            if (Styles.HorizontalAlignment.RIGHT.equals(style.getHorizontalAlign()) && imageWidth < (float)imageRectangle.width) {
                xMove = (float)imageRectangle.width - imageWidth - move * 3.0f / 2.0f;
            }
        }
        this.addImage(pdfTemplate, image, imageWidth, imageHeight, (float)imageRectangle.x + xMove, (float)imageRectangle.y + yMove);
    }

    private void drawBorder(Graphics g, PWPicture paintObj) {
        Style style = paintObj.getStyle();
        if (style.getBorder(Styles.Position.LEFT).isNull()) {
            return;
        }
        Rectangle rectangle = paintObj.getRectangle();
        StyleRender.drawBorders(this.lomToPixel(rectangle.x), this.lomToPixel(rectangle.y), this.lomToPixel(rectangle.width), this.lomToPixel(rectangle.height), style, g);
    }
}

