/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.execute.render.painter.pwpainer;

import com.google.zxing.BarcodeFormat;
import com.lowagie.text.Image;
import com.lowagie.text.pdf.PdfTemplate;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.io.ByteArrayOutputStream;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.print.core.data.field.MapField;
import kd.bos.print.core.execute.render.painter.pwpainer.BaseImagePainter;
import kd.bos.print.core.execute.render.painter.pwpainer.PicturePainter;
import kd.bos.print.core.model.widget.barcode.PWBarcode;
import kd.bos.print.core.model.widget.barcode.QRCodeUtils;

public class QRCodePainter
extends BaseImagePainter<PWBarcode> {
    private Log log = LogFactory.getLog(PicturePainter.class);

    @Override
    public void paint(Graphics g, PdfTemplate pdfTemplate) {
        PWBarcode pwBarcode = (PWBarcode)this.getPaintObj();
        MapField mapField = (MapField)pwBarcode.getOutputValue();
        Map config = (Map)mapField.getValue();
        Rectangle rectangle = pwBarcode.getRectangle();
        int width = rectangle.width;
        int height = rectangle.height;
        boolean widthSmaller = width < height;
        long drawWidth = widthSmaller ? (long)width : (long)height;
        config.put("suffix", "png");
        config.put("width", drawWidth);
        config.put("height", drawWidth);
        BarcodeFormat format = Enum.valueOf(BarcodeFormat.class, config.get("barcodeType").toString());
        String barText = (String)config.get("barcode");
        String imageKey = "QRCode-" + drawWidth + "-" + barText;
        Image image = (Image)this.getPaintContext().getShareResource().getImageShare().getImageFromCache(imageKey);
        if (image == null) {
            try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
                QRCodeUtils.generateBarcodePicture(os, format, config);
                image = Image.getInstance((byte[])os.toByteArray());
                this.getPaintContext().getShareResource().getImageShare().cacheImage(imageKey, image);
            }
            catch (Exception e) {
                this.log.warn("\u751f\u6210\u4e8c\u7ef4\u7801\u5931\u8d25", (Throwable)e);
                return;
            }
        }
        float drawX = rectangle.x;
        float drawY = rectangle.y;
        if (widthSmaller) {
            drawY += (float)(((long)height - drawWidth) / 2L);
        } else {
            drawX += (float)(((long)width - drawWidth) / 2L);
        }
        this.addImage(pdfTemplate, image, drawWidth, drawWidth, drawX, drawY);
    }
}

