/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.execute.render.painter.pwpainer;

import com.lowagie.text.pdf.PdfImportedPage;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.print.core.ctrl.kdf.util.style.Style;
import kd.bos.print.core.ctrl.kdf.util.style.StyleUtil;
import kd.bos.print.core.ctrl.kdf.util.style.Styles;
import kd.bos.print.core.execute.render.painter.BasePWPainter;
import kd.bos.print.core.model.ui.view.StyleRender;
import kd.bos.print.core.model.widget.PWRichText;

public class RichTextPainter
extends BasePWPainter<PWRichText> {
    @Override
    public void paint(Graphics g) {
        PWRichText pwRichText = (PWRichText)this.getPaintObj();
        try {
            this.paintSelf(g, pwRichText);
        }
        catch (IOException ex) {
            throw new KDBizException(ResManager.loadKDString((String)"PdfReader\u521b\u5efa\u5f02\u5e38\u3002", (String)"RichTextPainter_0", (String)"bos-print-ecore", (Object[])new Object[0]));
        }
        this.paintBorder(g, pwRichText);
    }

    protected void paintSelf(Graphics g, PWRichText pwRichText) throws IOException {
        PdfTemplate pdftemplate = this.context.getPdftemplate();
        PdfWriter pdfWriter = pdftemplate.getPdfWriter();
        ByteArrayOutputStream os = (ByteArrayOutputStream)pwRichText.getHtmlPDFos();
        try (PdfReader reader = new PdfReader(os.toByteArray());){
            Integer left = this.getPaperInfo().getR1PrintInfo().getMarginLeft();
            Integer x = pwRichText.getRectangle().x;
            Integer starX = left + x;
            PdfImportedPage page = pdfWriter.getImportedPage(reader, pwRichText.getPdfPageNum().intValue());
            Integer footerAndBottom = pwRichText.getFooterHeight() + pwRichText.getBottom();
            pdftemplate.addTemplate((PdfTemplate)page, (float)StyleUtil.lomToPt(starX.intValue()), (float)StyleUtil.lomToPt(footerAndBottom.intValue()));
        }
    }

    private void paintBorder(Graphics g, PWRichText pwRichText) {
        Style style = pwRichText.getStyle();
        if (style.getBorder(Styles.Position.LEFT).isNull()) {
            return;
        }
        Rectangle rectangle = pwRichText.getRectangle();
        StyleRender.drawBorders(this.lomToPixel(rectangle.x), this.lomToPixel(rectangle.y), this.lomToPixel(rectangle.width), this.lomToPixel(rectangle.height), style, g);
    }
}

