/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.execute.render.painter.pwpainer.image;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.print.core.ctrl.kdf.util.style.StyleUtil;
import kd.bos.print.core.ctrl.print.util.ImageFillUtil;
import kd.bos.print.core.ctrl.reportone.r1.print.common.R1PrintInfo;
import kd.bos.print.core.execute.render.painter.IPainter;
import kd.bos.print.core.execute.render.painter.PaintPaperInfo;
import kd.bos.print.core.execute.render.painter.PainterFactory;
import kd.bos.print.core.execute.render.painter.pwpainer.PaperPainter;
import kd.bos.print.core.execute.render.painter.pwpainer.image.RichText2ImagePainter;
import kd.bos.print.core.execute.render.painter.share.AwtImageShare;
import kd.bos.print.core.execute.render.painter.share.ImageShare;
import kd.bos.print.core.model.widget.AbstractPrintWidget;
import kd.bos.print.core.model.widget.PWRichText;

public class ImagePaperPainter
extends PaperPainter {
    public ImagePaperPainter(PaintPaperInfo paperInfo) {
        super(paperInfo);
    }

    @Override
    protected IPainter getPainter(AbstractPrintWidget widget) {
        if (widget instanceof PWRichText) {
            RichText2ImagePainter richTextPainter = new RichText2ImagePainter();
            richTextPainter.addPaintObj((PWRichText)widget);
            return richTextPainter;
        }
        return PainterFactory.get().getViewPainter();
    }

    @Override
    public void paint(Graphics g) {
        this.paintBackGround(g);
        this.paintPage(g);
    }

    @Override
    protected void paintBackGround(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        R1PrintInfo r1PrintInfo = this.getPaperInfo().getR1PrintInfo();
        if (!r1PrintInfo.isShowBgImage()) {
            return;
        }
        String bgImageUrl = r1PrintInfo.getBgImageUrl();
        if (StringUtils.isBlank((CharSequence)bgImageUrl)) {
            return;
        }
        ImageShare imageShare = this.context.getShareResource().getImageShare();
        AwtImageShare.ImageExt orGenImage = (AwtImageShare.ImageExt)imageShare.getOrGenImage(bgImageUrl);
        if (orGenImage == null) {
            return;
        }
        Dimension paperSize = this.paperInfo.getR1PrintInfo().getPaperSize();
        Rectangle2D.Float paintReact = new Rectangle2D.Float(0.0f, 1.0f, (float)StyleUtil.lomToPt(paperSize.width), (float)StyleUtil.lomToPt(paperSize.height));
        ImageFillUtil.draw(g2d, orGenImage.getImage(), paintReact, (byte)3);
    }
}

