/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.execute.render.painter.pwpainer.pagenum;

import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import kd.bos.print.core.ExecuteContext;
import kd.bos.print.core.ctrl.common.util.StringUtil;
import kd.bos.print.core.ctrl.kdf.util.style.Style;
import kd.bos.print.core.ctrl.kdf.util.style.StyleAttributes;
import kd.bos.print.core.ctrl.kdf.util.style.Styles;
import kd.bos.print.core.ctrl.reportone.r1.print.common.R1PrintInfo;
import kd.bos.print.core.execute.RuntimeModel;
import kd.bos.print.core.execute.render.painter.pwpainer.pagenum.PageNumItem;
import kd.bos.print.core.execute.render.painter.pwpainer.pagenum.PageNumWidget;
import kd.bos.print.core.model.IBindFieldSupport;
import kd.bos.print.core.model.designer.IR1Page;
import kd.bos.print.core.model.designer.TextObject;
import kd.bos.print.core.model.designer.common.IContainer;
import kd.bos.print.core.model.designer.common.IElement;
import kd.bos.print.core.model.designer.common.IReportObject;
import kd.bos.print.core.model.designer.grid.AbstractCell;
import kd.bos.print.core.model.designer.grid.AbstractGrid;
import kd.bos.print.core.model.designer.grid.AbstractRow;
import kd.bos.print.core.model.designer.grid.tabletail.ITableTailModel;
import kd.bos.print.core.model.designer.grid.tabletail.TableTail;
import kd.bos.print.core.model.widget.AbstractPrintWidget;
import kd.bos.print.core.model.widget.AbstractPrintWidgetText;
import kd.bos.print.core.model.widget.IPrintWidget;
import kd.bos.print.core.model.widget.IPrintWidgetContainer;
import kd.bos.print.core.model.widget.PWPage;
import kd.bos.print.core.model.widget.PWText;
import kd.bos.print.core.model.widget.grid.AbstractPWGrid;
import kd.bos.print.core.model.widget.grid.AbstractPWGridCell;
import kd.bos.print.core.model.widget.grid.AbstractPWGridColumn;
import kd.bos.print.core.model.widget.grid.AbstractPWGridRow;
import kd.bos.print.core.model.widget.grid.tabletail.ITableTailSupport;
import kd.bos.print.core.model.widget.grid.tabletail.PWTableTail;
import org.apache.commons.lang3.StringUtils;

public class PageNumUtil {
    private static boolean isTotalTextObj(IElement widget) {
        if (!(widget instanceof TextObject) && !(widget instanceof AbstractCell)) {
            return false;
        }
        IBindFieldSupport pwText = (IBindFieldSupport)((Object)widget);
        String datasource = pwText.getDatasource();
        String bindField = pwText.getBindField();
        return StringUtil.equals(datasource, "$DsKey=[System]") && StringUtils.isNotBlank((CharSequence)bindField) && bindField.contains("getPageTotal()");
    }

    private static boolean totalWidgetNeedToDraw(IPrintWidget widget) {
        if (!PageNumUtil.isTotalWidget(widget)) {
            return false;
        }
        PWText pwText = (PWText)widget;
        return StringUtils.isNotBlank((CharSequence)pwText.getOutputText());
    }

    public static boolean isTotalWidget(IPrintWidget widget) {
        if (!(widget instanceof PWText)) {
            return false;
        }
        PWText pwText = (PWText)widget;
        String datasource = pwText.getDatasource();
        String bindField = pwText.getBindField();
        return StringUtil.equals(datasource, "$DsKey=[System]") && StringUtils.isNotBlank((CharSequence)bindField) && bindField.contains("getPageTotal()");
    }

    public static boolean hasTotalWidget(List<RuntimeModel> runModelList) {
        boolean flag = false;
        int modelIndex = 1;
        for (RuntimeModel runtimeModel : runModelList) {
            List<IR1Page> pages = runtimeModel.getReportModel().getPages();
            flag = flag ? flag : PageNumUtil.modifyDesignTotalWidgetId(modelIndex, pages);
            ++modelIndex;
        }
        return flag;
    }

    public static boolean hasEconomize(List<RuntimeModel> runtimeModels) {
        ExecuteContext executeContext = ExecuteContext.get();
        if (executeContext.isHorEconomizePaper() || executeContext.isVerEconomizePaper()) {
            return true;
        }
        for (RuntimeModel rm : runtimeModels) {
            R1PrintInfo r1PrintInfo = rm.getReportModel().getR1PrintInfo();
            if (!r1PrintInfo.isVerEconomizePaper() && !r1PrintInfo.isHorEconomizePaper()) continue;
            return true;
        }
        return false;
    }

    public static <T extends IElement> boolean modifyDesignTotalWidgetId(int prefix, List<T> designPages) {
        boolean hasTotalWidget = false;
        if (designPages == null || designPages.isEmpty()) {
            return hasTotalWidget;
        }
        for (IElement reportObject : designPages) {
            TableTail tableTail;
            if (reportObject instanceof IContainer) {
                List children = ((IContainer)((Object)reportObject)).getChildren();
                boolean tempFlag = PageNumUtil.modifyDesignTotalWidgetId(prefix, children);
                hasTotalWidget = hasTotalWidget ? hasTotalWidget : tempFlag;
                continue;
            }
            if (PageNumUtil.isTotalTextObj(reportObject)) {
                reportObject.setId(prefix + reportObject.getId());
                hasTotalWidget = true;
                continue;
            }
            if (!(reportObject instanceof AbstractGrid)) continue;
            AbstractGrid layoutGrid = (AbstractGrid)reportObject;
            int rowsCount = layoutGrid.getRowsCount();
            int columnsCount = layoutGrid.getColumnsCount();
            for (int i = 0; i < rowsCount; ++i) {
                AbstractRow row = layoutGrid.getRow(i);
                for (int j = 0; j < columnsCount; ++j) {
                    AbstractCell cell = row.getCell(j);
                    if (cell == null) continue;
                    List children = cell.getChildren();
                    if (children != null && children.size() > 0) {
                        boolean tempFlag = PageNumUtil.modifyDesignTotalWidgetId(prefix, children);
                        hasTotalWidget = hasTotalWidget ? hasTotalWidget : tempFlag;
                        continue;
                    }
                    if (!PageNumUtil.isTotalTextObj(cell)) continue;
                    cell.setId(prefix + cell.getId());
                    hasTotalWidget = true;
                }
            }
            if (!(reportObject instanceof ITableTailModel) || (tableTail = ((ITableTailModel)((Object)reportObject)).getTableTail()) == null) continue;
            List<IReportObject> children = tableTail.getChildren();
            boolean tempFlag = PageNumUtil.modifyDesignTotalWidgetId(prefix, children);
            hasTotalWidget = hasTotalWidget ? hasTotalWidget : tempFlag;
        }
        return hasTotalWidget;
    }

    public static <T extends IPrintWidget> void recoreTotalWidget(List<T> widgets, int marginLeft, int marginTop, int pageWidth, int pageHeight, Map<String, PageNumWidget> totalWidgetMap) {
        Consumer<PWText> consumer = pwText -> totalWidgetMap.put(pwText.getId(), new PageNumWidget((PWText)pwText, marginLeft, marginTop, pageWidth, pageHeight));
        PageNumUtil.recoreTotalWidget(widgets, consumer);
    }

    public static <T extends IPrintWidget> void recoreTotalWidget(List<T> widgets, Consumer<PWText> consumer) {
        if (widgets == null || widgets.isEmpty()) {
            return;
        }
        for (IPrintWidget widget : widgets) {
            PWTableTail tableTail;
            if (widget instanceof IPrintWidgetContainer) {
                IPrintWidgetContainer container = (IPrintWidgetContainer)widget;
                List children = container.getChildren();
                PageNumUtil.recoreTotalWidget(children, consumer);
                continue;
            }
            if (PageNumUtil.isTotalWidget(widget)) {
                PWText target = (PWText)widget;
                consumer.accept(target);
                continue;
            }
            if (!(widget instanceof AbstractPWGrid)) continue;
            AbstractPWGrid layoutGrid = (AbstractPWGrid)widget;
            int rowsCount = layoutGrid.getRowsCount();
            int columnsCount = layoutGrid.getColumnCount();
            for (int i = 0; i < rowsCount; ++i) {
                Object row = layoutGrid.getRow(i);
                for (int j = 0; j < columnsCount; ++j) {
                    Object cell = ((AbstractPWGridRow)row).getCell(j);
                    if (cell == null) continue;
                    List<IPrintWidget> cellChildren = ((AbstractPWGridCell)cell).getChildren();
                    if (cellChildren != null && !cellChildren.isEmpty()) {
                        for (IPrintWidget cellChild : cellChildren) {
                            if (!PageNumUtil.isTotalWidget(cellChild)) continue;
                            consumer.accept((PWText)cellChild);
                        }
                        continue;
                    }
                    if (!PageNumUtil.isTotalWidget(cell)) continue;
                    PWText pwText = PageNumUtil.cellCopy(cell, ((AbstractPWGridColumn)layoutGrid.getColumn(j)).getWidth(), ((AbstractPWGridRow)row).getHeight());
                    consumer.accept(pwText);
                }
            }
            if (!(widget instanceof ITableTailSupport) || (tableTail = ((ITableTailSupport)((Object)widget)).getTableTail()) == null) continue;
            PageNumUtil.recoreTotalWidget(tableTail.getChildren(), consumer);
        }
    }

    private static PWText cellCopy(AbstractPWGridCell cell, int width, int height) {
        PWText copy = new PWText();
        copy.setId(cell.getId());
        Style cellStyle = cell.getStyle();
        StyleAttributes sa = Styles.getEmptySA();
        sa.setFontSize(cellStyle.getFontSizeF());
        sa.setFont(cellStyle.getFont());
        sa.setFontName(cellStyle.getFontName());
        sa.setFontColor(cellStyle.getFontColor());
        copy.setStyle(Styles.getStyle(sa));
        copy.setBindField(cell.getBindField());
        copy.setDatasource(cell.getDatasource());
        copy.setPrintable(cell.isPrintable());
        copy.setType("Text");
        Rectangle rectangle = copy.getRectangle();
        if (rectangle == null) {
            rectangle = new Rectangle();
        }
        rectangle.width = width;
        rectangle.height = height;
        copy.setRectangle(rectangle);
        return copy;
    }

    public static List<PageNumItem> removeTotalPageWidget(PWPage pwPage) {
        ArrayList<PageNumItem> pageNumItems = new ArrayList<PageNumItem>();
        List pageChildren = pwPage.getChildren();
        Iterator iterator = pageChildren.iterator();
        while (iterator.hasNext()) {
            AbstractPrintWidget widget = (AbstractPrintWidget)iterator.next();
            if (PageNumUtil.totalWidgetNeedToDraw(widget)) {
                pageNumItems.add(new PageNumItem(widget.getId(), widget.getRectangle().x, widget.getRectangle().y, widget.getPageIndex() + 1));
                iterator.remove();
                continue;
            }
            if (widget instanceof IPrintWidgetContainer) {
                IPrintWidgetContainer container = (IPrintWidgetContainer)((Object)widget);
                List children = container.getChildren();
                if (children == null || children.isEmpty()) continue;
                Iterator childrenIter = children.iterator();
                while (childrenIter.hasNext()) {
                    AbstractPrintWidget child = (AbstractPrintWidget)childrenIter.next();
                    if (PageNumUtil.totalWidgetNeedToDraw(child)) {
                        pageNumItems.add(new PageNumItem(child.getId(), container.getRectangle().x + child.getRectangle().x, container.getRectangle().y + child.getRectangle().y, child.getPageIndex() + 1));
                        childrenIter.remove();
                        continue;
                    }
                    if (!(child instanceof AbstractPWGrid)) continue;
                    PageNumUtil.removeGridTotalPageWidget(pageNumItems, (AbstractPWGrid)child, container.getRectangle().x, container.getRectangle().y);
                }
                continue;
            }
            if (!(widget instanceof AbstractPWGrid)) continue;
            PageNumUtil.removeGridTotalPageWidget(pageNumItems, (AbstractPWGrid)widget);
        }
        return pageNumItems;
    }

    private static void removeGridTotalPageWidget(List<PageNumItem> pageNumItems, AbstractPWGrid widget) {
        PageNumUtil.removeGridTotalPageWidget(pageNumItems, widget, 0, 0);
    }

    private static void removeGridTotalPageWidget(List<PageNumItem> pageNumItems, AbstractPWGrid widget, int addX, int addY) {
        AbstractPWGrid layoutGrid = widget;
        List outputRows = layoutGrid.getOutputRows();
        int columnCount = layoutGrid.getColumnCount();
        int startY = layoutGrid.getRectangle().y;
        for (int i = 0; i < outputRows.size(); ++i) {
            int startX = layoutGrid.getRectangle().x;
            AbstractPWGridRow row = (AbstractPWGridRow)outputRows.get(i);
            for (int j = 0; j < columnCount; ++j) {
                Object cell = row.getCell(j);
                if (cell == null) {
                    startX += ((AbstractPWGridColumn)layoutGrid.getColumn(j)).getWidth();
                    continue;
                }
                List<IPrintWidget> children = ((AbstractPWGridCell)cell).getChildren();
                if (children != null && !children.isEmpty()) {
                    Iterator<IPrintWidget> childrenIter = children.iterator();
                    while (childrenIter.hasNext()) {
                        IPrintWidget child = childrenIter.next();
                        if (!PageNumUtil.totalWidgetNeedToDraw(child)) continue;
                        PWText target = (PWText)child;
                        pageNumItems.add(new PageNumItem(target.getId(), addX + startX + target.getRectangle().x, addY + startY + target.getRectangle().y, target.getPageIndex() + 1));
                        childrenIter.remove();
                    }
                } else if (PageNumUtil.totalWidgetNeedToDraw(cell)) {
                    PWText copy = (PWText)((AbstractPWGridCell)cell).copy();
                    ((AbstractPrintWidgetText)cell).setOutputText("");
                    pageNumItems.add(new PageNumItem(copy.getId(), addX + startX, addY + startY, copy.getPageIndex() + 1));
                }
                startX += ((AbstractPWGridColumn)layoutGrid.getColumn(j)).getWidth();
            }
            startY += row.getHeight();
        }
    }
}

