/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.execute.render.painter.pwpainer.pagenum;

import com.lowagie.text.pdf.FontMapper;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfStamper;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.print.core.ExecuteContext;
import kd.bos.print.core.ExecuteService;
import kd.bos.print.core.ctrl.common.KDToolkit;
import kd.bos.print.core.ctrl.kdf.util.style.StyleUtil;
import kd.bos.print.core.ctrl.print.io.PrintFontMapper;
import kd.bos.print.core.exception.PrintException;
import kd.bos.print.core.execute.ExecuteLife;
import kd.bos.print.core.execute.PrintJobPool;
import kd.bos.print.core.execute.render.painter.IPainter;
import kd.bos.print.core.execute.render.painter.PaintPaperInfo;
import kd.bos.print.core.execute.render.painter.PainterFactory;
import kd.bos.print.core.execute.render.painter.pwpainer.pagenum.PageNumItem;
import kd.bos.print.core.execute.render.painter.pwpainer.pagenum.PageNumRecord;
import kd.bos.print.core.execute.render.painter.pwpainer.pagenum.PageNumWidget;
import kd.bos.print.core.model.widget.AbstractPrintWidget;
import kd.bos.print.core.model.widget.PWText;
import kd.bos.print.core.service.PrtAttach;
import kd.bos.print.core.utils.PrintConst;
import kd.bos.session.SystemPropertyUtils;

public class PaperNumRender {
    private static Log log = LogFactory.getLog(PaperNumRender.class);
    private PageNumRecord pageNumRecord;
    private ExecuteLife executeLife;
    private int ontPdfPage = PrintConst.onePdfMaxPage();
    private int pageTotal = 0;
    private PaintPaperInfo paperInfo = null;

    public PaperNumRender(PageNumRecord pageNumRecord, int pageTotal, ExecuteLife executeLife) {
        this(pageNumRecord, pageTotal, executeLife, null);
    }

    public PaperNumRender(PageNumRecord pageNumRecord, int pageTotal, ExecuteLife executeLife, PaintPaperInfo paperInfo) {
        this.pageNumRecord = pageNumRecord;
        this.pageTotal = pageTotal;
        this.executeLife = executeLife;
        this.paperInfo = paperInfo;
    }

    public void render(PrtAttach attach) {
        List<PrtAttach.AttachDetail> attachDetails = attach.getAttachDetail();
        int num = 1;
        String renderAttachNum = SystemPropertyUtils.getProptyByTenant((String)"PRT_RENDER_ATTACH_NUM", (String)RequestContext.get().getTenantId());
        if (StringUtils.isNotBlank((CharSequence)renderAttachNum)) {
            num = Integer.parseInt(renderAttachNum);
        }
        if (attachDetails.size() <= num) {
            for (PrtAttach.AttachDetail detail : attachDetails) {
                this.renderAttach(detail);
            }
        } else {
            LinkedBlockingQueue<PrtAttach.AttachDetail> blockingQueue = new LinkedBlockingQueue<PrtAttach.AttachDetail>(attachDetails.size());
            blockingQueue.addAll(attachDetails);
            CountDownLatch countDownLatch = new CountDownLatch(attachDetails.size());
            AtomicBoolean isSuccess = new AtomicBoolean(true);
            StringBuffer errorBuffer = new StringBuffer();
            ExecuteContext executeContext = ExecuteContext.get();
            for (int thread = 2; thread >= 1; --thread) {
                PrintJobPool.submit(() -> {
                    ExecuteContext.set(executeContext);
                    while (!blockingQueue.isEmpty()) {
                        PrtAttach.AttachDetail attachDetail = (PrtAttach.AttachDetail)blockingQueue.poll();
                        try {
                            if (this.executeLife.isStop() || !isSuccess.get()) continue;
                            this.renderAttach(attachDetail);
                        }
                        catch (Exception e) {
                            log.error((Throwable)e);
                            isSuccess.set(false);
                            errorBuffer.append(e.getMessage()).append(";");
                        }
                        finally {
                            countDownLatch.countDown();
                        }
                    }
                    return true;
                });
            }
            try {
                countDownLatch.await();
            }
            catch (InterruptedException e) {
                log.error((Throwable)e);
                throw new PrintException("-1", e);
            }
            if (!isSuccess.get()) {
                throw new PrintException("-1", errorBuffer.toString());
            }
        }
    }

    private void renderAttach(PrtAttach.AttachDetail detail) {
        Map<Integer, Map<Integer, List<PageNumItem>>> pageNumItems = this.pageNumRecord.getPageNumItemMap();
        if (pageNumItems == null || this.pageNumRecord.getPageNumWidgetMap() == null) {
            this.saveAttach(detail);
        } else {
            int attachIndex = detail.getSeq();
            Map<Integer, List<PageNumItem>> integerListMap = pageNumItems.get(attachIndex);
            if (integerListMap == null) {
                this.saveAttach(detail);
            } else {
                this.renderPageNumSaveAttach(detail, integerListMap);
            }
        }
    }

    private void saveAttach(PrtAttach.AttachDetail detail) {
        String path = detail.getFilePath();
        try (FileInputStream inputStream = new FileInputStream(path);){
            String filePath = ExecuteService.getAttachService().savePrtFile(detail.getFileName(), inputStream);
            detail.setFilePath(filePath);
        }
        catch (Exception e) {
            throw new PrintException("-1", e);
        }
    }

    private void renderPageNumSaveAttach(PrtAttach.AttachDetail detail, Map<Integer, List<PageNumItem>> integerListMap) {
        String path = detail.getFilePath();
        int pdfIndex = detail.getSeq();
        PdfStamper stamper = null;
        try (PdfReader reader = null;
             ByteArrayOutputStream os = new ByteArrayOutputStream();){
            reader = new PdfReader(path);
            stamper = new PdfStamper(reader, (OutputStream)os);
            for (Map.Entry<Integer, List<PageNumItem>> entry : integerListMap.entrySet()) {
                int pageIndex = entry.getKey();
                List<PageNumItem> pageNumItems = entry.getValue();
                int thisPage = pageIndex - (pdfIndex - 1) * this.ontPdfPage;
                PdfContentByte pdfContentByte = stamper.getOverContent(thisPage);
                if (pdfContentByte == null) {
                    log.info("\u9875\u7801\u83b7\u53d6\u9519\u8bef\uff0c\u8df3\u8fc7\u9875\u7801\u7ed8\u5236\u3002");
                    continue;
                }
                for (PageNumItem pageNumItem : pageNumItems) {
                    PageNumWidget pageNumWidget = this.pageNumRecord.getPageNumWidgetMap().get(pageNumItem.getKey());
                    if (pageNumWidget == null) {
                        log.info("\u9875\u7801\u83b7\u53d6\u9519\u8bef\uff0c\u8df3\u8fc7\u9875\u7801\u7ed8\u5236\u3002");
                        continue;
                    }
                    PWText oriPwText = pageNumWidget.getPwText();
                    PWText pwText = (PWText)oriPwText.copy();
                    Rectangle rectangle = pwText.getRectangle();
                    rectangle.y = pageNumItem.getrY1();
                    rectangle.x = pageNumItem.getrX1();
                    String outputText = pwText.getBindField();
                    outputText = pageNumItem.getCurrentPageIndex() != null ? this.replacePageValue(outputText, pageNumItem.getCurrentPageIndex(), this.pageTotal) : this.replacePageValue(outputText, pageIndex, this.pageTotal);
                    pwText.setOutputText(outputText);
                    Graphics2D g2d = pdfContentByte.createGraphics((float)StyleUtil.lomToPt(pageNumWidget.getPageWidth()), (float)StyleUtil.lomToPt(pageNumWidget.getPageHeight()), (FontMapper)PrintFontMapper.createInstance());
                    g2d.scale(72.0 / (double)KDToolkit.getCurrentDpi(), 72.0 / (double)KDToolkit.getCurrentDpi());
                    g2d.translate(StyleUtil.lomToPixel(pageNumWidget.getMarginLeft()), StyleUtil.lomToPixel(pageNumWidget.getMarginTop()));
                    this.viewPainerPaint(pwText, g2d);
                    g2d.dispose();
                }
            }
            stamper.close();
            os.flush();
            String filePath = ExecuteService.getAttachService().savePrtFile(detail.getFileName(), os.toByteArray());
            detail.setFilePath(filePath);
        }
    }

    private void viewPainerPaint(AbstractPrintWidget widget, Graphics2D g2d) {
        IPainter painter = PainterFactory.get().getPainter(widget);
        painter.addPaintObj(widget);
        painter.setPaperInfo(this.paperInfo);
        painter.paint(g2d);
    }

    private String replacePageValue(String totalStr, int pageNum, int totalPageNum) {
        totalStr = totalStr.substring(1);
        String[] arr = totalStr.split("\\+");
        StringBuilder builder = new StringBuilder();
        for (String str : arr) {
            str = str.replace("\"", "");
            if ("getPageNumber()".equals(str = str.trim())) {
                builder.append(pageNum);
                continue;
            }
            if ("getPageTotal()".equals(str)) {
                builder.append(totalPageNum);
                continue;
            }
            builder.append(str);
        }
        return builder.toString();
    }
}

