/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.execute.render.painter.share;

import com.google.common.collect.Interner;
import com.google.common.collect.Interners;
import java.util.LinkedHashMap;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public abstract class ImageShare<T> {
    private Log log = LogFactory.getLog(this.getClass());
    private ImageCache imageCache = new ImageCache();
    private Interner<String> interner = Interners.newWeakInterner();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T getOrGenImage(String imageKey) {
        if (this.imageCache.containsKey(imageKey)) {
            return (T)this.imageCache.get(imageKey);
        }
        String string = (String)this.interner.intern((Object)imageKey);
        synchronized (string) {
            if (this.imageCache.containsKey(imageKey)) {
                return (T)this.imageCache.get(imageKey);
            }
            try {
                T image = this.loadImage(imageKey);
                this.imageCache.put(imageKey, image);
            }
            catch (Exception e) {
                this.log.error("\u83b7\u53d6\u56fe\u7247\u5931\u8d25\uff1a", (Throwable)e);
                this.imageCache.put(imageKey, null);
                return null;
            }
            return (T)this.imageCache.get(imageKey);
        }
    }

    public void cacheImage(String imageKey, T image) {
        this.imageCache.put(imageKey, image);
    }

    public T getImageFromCache(String imageKey) {
        return (T)this.imageCache.get(imageKey);
    }

    public void release() {
        this.imageCache.clear();
        this.imageCache = null;
    }

    protected abstract T loadImage(String var1) throws Exception;

    protected abstract long getSize(T var1);

    private class ImageCache
    extends LinkedHashMap<String, T> {
        private static final long maxMemSize = 0x6400000L;
        private static final long maxItemSize = 0x1400000L;
        private static final int maxItems = 50;
        private long memSize = 0L;

        private ImageCache() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T put(String key, T value) {
            ImageCache imageCache = this;
            synchronized (imageCache) {
                long size = 0L;
                if (value != null) {
                    size = ImageShare.this.getSize(value);
                }
                if (size > 0x1400000L) {
                    ImageShare.this.log.debug("\u6253\u5370\u56fe\u7247\u6587\u4ef6\u592a\u5927\uff0c\u4e0d\u8fdb\u884c\u7f13\u5b58");
                    return null;
                }
                this.memSize += size;
                return super.put(key, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            ImageCache imageCache = this;
            synchronized (imageCache) {
                super.clear();
                this.memSize = 0L;
            }
        }

        @Override
        public boolean removeEldestEntry(Map.Entry eldest) {
            if (this.size() > 50 && this.memSize > 0x6400000L) {
                Object image = eldest.getValue();
                this.memSize -= ImageShare.this.getSize(image);
                return true;
            }
            return false;
        }
    }
}

