/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.execute.render.painter.share;

import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.print.core.ExecuteContext;
import kd.bos.print.core.ExecuteService;
import kd.bos.print.core.exception.PrintException;
import kd.bos.print.core.execute.render.painter.share.ImageShare;
import kd.bos.print.core.execute.render.painter.share.PdfImageShare;
import kd.bos.print.core.service.PrtAttach;
import kd.bos.print.core.utils.PrintConst;

public class ShareResource {
    private ImageShare imageShare = new PdfImageShare();
    private int pdfPageSize;
    private AtomicInteger disablePageSize = new AtomicInteger(0);
    private String fileName;
    private PrtAttach attach = new PrtAttach();

    public ShareResource() {
        this.attach.setTaskId(ExecuteContext.get().getTaskId());
        this.attach.setOrgId(ExecuteService.getUserService().getOrgId());
        this.attach.setAppId(ExecuteContext.get().getAppId());
        this.attach.setUserId(ExecuteService.getUserId());
        this.attach.setFormId(ExecuteContext.get().getFormId());
        this.attach.setDiskType(ExecuteContext.get().getpFileStorageType().getCode());
        this.attach.setExtType(ExecuteContext.get().getExpType());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAttachList(List<PrtAttach.AttachDetail> attachDetails, int pdfSize) {
        Class<ShareResource> clazz = ShareResource.class;
        synchronized (ShareResource.class) {
            this.pdfPageSize += pdfSize;
            for (PrtAttach.AttachDetail detail : attachDetails) {
                this.attach.addAttachDetail(detail);
                int maxZipFileNum = PrintConst.getMaxBillNoCreateFileNum();
                if (!ExecuteContext.get().isFileCreateBySingleBill() || this.attach.getAttachDetail().size() <= maxZipFileNum) continue;
                throw new PrintException("2", ResManager.loadKDString((String)"\u6309\u4e0d\u540c\u5355\u636e\u751f\u6210\u591a\u4e2aPDF\uff0c\u6279\u91cf\u6253\u5370\u6700\u5927\u652f\u6301%s\u5f20\u5355\u636e\u3002", (String)"AbstractPrint_48", (String)"bos-noteprint", (Object[])new Object[]{maxZipFileNum}));
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    public int getPdfPageSize() {
        return this.pdfPageSize;
    }

    public int getToalPageSize() {
        return this.pdfPageSize - this.disablePageSize.get();
    }

    public AtomicInteger getDisablePageSize() {
        return this.disablePageSize;
    }

    public PrtAttach getAttach() {
        return this.attach;
    }

    public ImageShare getImageShare() {
        return this.imageShare;
    }

    public void setImageShare(ImageShare imageShare) {
        this.imageShare = imageShare;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public void release() {
        this.imageShare.release();
        this.imageShare = null;
    }
}

