/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.execute.utils;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.orm.util.StringUtils;
import kd.bos.print.core.ctrl.reportone.r1.print.engine.IWidgetExecuteHelper;
import kd.bos.print.core.data.MainDataVisitor;
import kd.bos.print.core.data.field.DecimalField;
import kd.bos.print.core.data.field.Field;
import kd.bos.print.core.data.field.NumberField;
import kd.bos.print.core.script.ScriptSystemFun;

public class PrtFileNameUtil {
    private static final String FILE_NAME_K = "key";
    private static String defSpeSymbol = "/\\*\"?:<>|";

    public static List<String> parseField(List<Object> fileNameData) {
        ArrayList<String> result = new ArrayList<String>(10);
        if (CollectionUtils.isEmpty(fileNameData)) {
            return result;
        }
        for (Object next : fileNameData) {
            Map map;
            if (!(next instanceof Map) || !(map = (Map)next).containsKey(FILE_NAME_K) || null == map.get(FILE_NAME_K)) continue;
            result.add((String)map.get(FILE_NAME_K));
        }
        return result;
    }

    public static String parseFieldAndString(List<Object> fileName, IWidgetExecuteHelper.IDataHelper helper, String formId, boolean resetMainDs) {
        if (CollectionUtils.isEmpty(fileName) || null == helper || StringUtils.isEmpty((Object)formId)) {
            return null;
        }
        MainDataVisitor dataVisitor = null;
        Iterator<Object> itr = fileName.iterator();
        StringBuilder sb = new StringBuilder();
        while (itr.hasNext()) {
            Object next = itr.next();
            if (next instanceof Map) {
                Map map = (Map)next;
                if (!map.containsKey(FILE_NAME_K) || null == map.get(FILE_NAME_K)) continue;
                String k = (String)map.get(FILE_NAME_K);
                if ("$sys.printer".equals(k)) {
                    ScriptSystemFun fun = new ScriptSystemFun();
                    sb.append(fun.getUserName());
                    continue;
                }
                if ("$sys.printTime".equals(k)) {
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
                    sb.append(sdf.format(new Date()));
                    continue;
                }
                dataVisitor = (MainDataVisitor)helper.getDataVisitor(formId);
                if (dataVisitor == null) continue;
                Field fieldValue = dataVisitor.getField(k);
                if (fieldValue instanceof NumberField) {
                    BigDecimal bigDecimal = PrtFileNameUtil.toBigDecimal(fieldValue.getValue());
                    if (bigDecimal.compareTo(BigDecimal.ZERO) == 0 && !((NumberField)fieldValue).isShowZero()) continue;
                    if (fieldValue instanceof DecimalField) {
                        int scale = ((DecimalField)fieldValue).getScale();
                        bigDecimal = bigDecimal.setScale(scale);
                    }
                    sb.append(bigDecimal.toPlainString());
                    continue;
                }
                if (fieldValue == null) continue;
                sb.append(fieldValue);
                continue;
            }
            if (!(next instanceof String)) continue;
            sb.append(next);
        }
        if (dataVisitor != null && resetMainDs) {
            dataVisitor.resetPkIndex();
        }
        if ((sb = PrtFileNameUtil.replaceSpeSymbol(sb.toString(), defSpeSymbol)).length() > 100) {
            sb.setLength(100);
        }
        return sb.toString();
    }

    public static String parseFieldAndString(List<Object> fileName, IWidgetExecuteHelper.IDataHelper helper, String formId) {
        return PrtFileNameUtil.parseFieldAndString(fileName, helper, formId, true);
    }

    private static BigDecimal toBigDecimal(Object value) {
        BigDecimal ret = BigDecimal.ZERO;
        if (value instanceof BigDecimal) {
            ret = (BigDecimal)value;
        } else if (value instanceof String) {
            try {
                ret = new BigDecimal(((String)value).trim());
            }
            catch (Exception exception) {}
        } else if (value instanceof Integer) {
            ret = new BigDecimal((Integer)value);
        } else if (value instanceof BigInteger) {
            ret = new BigDecimal((BigInteger)value);
        } else if (value instanceof Long) {
            ret = new BigDecimal((Long)value);
        } else if (value instanceof Number) {
            ret = BigDecimal.valueOf(((Number)value).doubleValue());
        }
        return ret;
    }

    private static StringBuilder replaceSpeSymbol(String fileName, String speSymbol) {
        for (int i = 0; i < speSymbol.length(); ++i) {
            char s = speSymbol.charAt(i);
            if (!fileName.contains(String.valueOf(s))) continue;
            fileName = fileName.replace(String.valueOf(s), "");
        }
        return new StringBuilder(fileName);
    }
}

