/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.label.cpcl;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import javax.imageio.ImageIO;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class CPCL {
    private static final Log log = LogFactory.getLog(CPCL.class);
    static final String LINE = "\n";
    static final byte[] LINE_BYTES = CPCL.toBytes("\n");

    public static byte[] cut(int h) {
        return CPCL.cut(h, -1);
    }

    public static byte[] cut(int h, int time) {
        if (time >= 0) {
            return CPCL.toBytes("CUT " + h + "," + time + "" + LINE);
        }
        return CPCL.toBytes("CUT " + h + LINE);
    }

    public static byte[] area(int offset, int height, int qty) {
        return CPCL.toBytes("! " + offset + " 203 203 " + height + " " + qty + LINE);
    }

    public static byte[] area(int offset, int dpi, int height, int qty) {
        return CPCL.toBytes("! " + offset + " " + dpi + " " + dpi + " " + height + " " + qty + LINE);
    }

    public static byte[] pageWidth(int width) {
        return CPCL.toBytes("PW " + width + LINE);
    }

    public static byte[] density(int density) {
        return CPCL.toBytes("DENSITY " + density + LINE);
    }

    public static byte[] text(int font, int fontSize, int x, int y, String data) {
        return CPCL.text(0, font, fontSize, x, y, data);
    }

    public static byte[] text(int degree, int font, int fontSize, int x, int y, String data) {
        String command;
        switch (degree) {
            case 90: {
                command = "TEXT90";
                break;
            }
            case 180: {
                command = "TEXT180";
                break;
            }
            case 270: {
                command = "TEXT270";
                break;
            }
            default: {
                command = "TEXT";
            }
        }
        return CPCL.toBytes(command + " " + font + " " + fontSize + " " + x + " " + y + " " + data + LINE);
    }

    public static byte[] line(Point fromPoint, Point toPoint, int width) {
        return CPCL.line(fromPoint.x, fromPoint.y, toPoint.x, toPoint.y, width);
    }

    public static byte[] line(int x0, int y0, int x1, int y1, int width) {
        return CPCL.toBytes("LINE " + x0 + " " + y0 + " " + x1 + " " + y1 + " " + width + LINE);
    }

    public static byte[] barCodeText(boolean on, int fontNumber, int fontSize, int offset) {
        if (on) {
            return CPCL.toBytes("BARCODE-TEXT " + fontNumber + " " + fontSize + " " + offset + LINE);
        }
        return CPCL.toBytes("BARCODE-TEXT OFF\n");
    }

    public static byte[] barCode(boolean isH, String type, int width, int ratio, int height, int x, int y, String data) {
        if (isH) {
            return CPCL.toBytes("B " + type + " " + width + " " + ratio + " " + height + " " + x + " " + y + " " + data + LINE);
        }
        return CPCL.toBytes("VB " + type + " " + width + " " + ratio + " " + height + " " + x + " " + y + " " + data + LINE);
    }

    public static byte[] qrCode(String ecc, int x, int y, int m, int u, String data) {
        return CPCL.toBytes("BARCODE QR " + x + " " + y + " M " + m + " U " + u + LINE + ecc + "A," + data + LINE + "ENDQR" + LINE);
    }

    public static byte[] imageCG(int x, int y, String filename) {
        return CPCL.imageCG(x, y, ImageUtils.readImage(filename));
    }

    public static byte[] imageCG(int x, int y, BufferedImage image) {
        byte[] bitmap = ImageUtils.image2Bitmap(image);
        return CPCL.imageCG(image.getWidth(), image.getHeight(), x, y, bitmap);
    }

    public static byte[] imageCG(int w, int h, int x, int y, byte[] bitmap) {
        return CPCL.merge(CPCL.toBytes("CG " + ImageUtils.byteWidth(w) + " " + h + " " + x + " " + y + " "), bitmap, LINE_BYTES);
    }

    public static byte[] imageEG(int x, int y, String filename) {
        return CPCL.imageEG(x, y, ImageUtils.readImage(filename));
    }

    public static byte[] imageEG(int x, int y, BufferedImage image) {
        byte[] bitmap = ImageUtils.image2Bitmap(image);
        StringBuilder builder = new StringBuilder();
        for (byte b : bitmap) {
            builder.append(String.format("%02X", b & 0xFF));
        }
        byte[] bitmapHex = CPCL.toBytes(builder.toString());
        return CPCL.merge(CPCL.toBytes("EG " + ImageUtils.byteWidth(image.getWidth()) + " " + image.getHeight() + " " + x + " " + y + " "), bitmapHex, LINE_BYTES);
    }

    public static byte[] imageGG(int x, int y, String filename) {
        return CPCL.imageGG(x, y, ImageUtils.readImage(filename));
    }

    public static byte[] imageGG(int x, int y, int maxSize, String filename) {
        return CPCL.imageGG(x, y, maxSize, ImageUtils.readImage(filename));
    }

    public static byte[] imageGG(int x, int y, BufferedImage image) {
        return CPCL.imageGG(x, y, 4096, image);
    }

    public static byte[] imageGG(int x, int y, int maxSize, BufferedImage image) {
        int width = image.getWidth();
        int height = image.getHeight();
        int byteWidth = ImageUtils.byteWidth(width);
        int maxHeight = maxSize / byteWidth;
        int imageCount = (int)Math.ceil((double)height * 1.0 / (double)maxHeight);
        byte[] bitmap = ImageUtils.image2Bitmap(image);
        ByteArrayOutputStream instructions = new ByteArrayOutputStream();
        for (int n = 0; n < imageCount; ++n) {
            int subY = y + maxHeight * n;
            int subHeight = n == imageCount - 1 ? height - maxHeight * n : maxHeight;
            byte[] subBitmap = new byte[byteWidth * subHeight];
            System.arraycopy(bitmap, maxHeight * n * byteWidth, subBitmap, 0, subBitmap.length);
            byte[] subBitmapCompressed = null;
            byte[] instruction = subBitmapCompressed == null || subBitmapCompressed.length == 0 || subBitmapCompressed.length >= subBitmap.length ? CPCL.imageCG(width, subHeight, x, subY, subBitmap) : CPCL.imageGG(width, subHeight, x, subY, subBitmapCompressed);
            if (instruction == null) continue;
            instructions.write(instruction, 0, instruction.length);
        }
        return instructions.toByteArray();
    }

    public static byte[] imageGG(int w, int h, int x, int y, byte[] bitmapCompressed) {
        return CPCL.merge(CPCL.toBytes("GG " + ImageUtils.byteWidth(w) + " " + h + " " + x + " " + y + " " + bitmapCompressed.length + " "), bitmapCompressed, LINE_BYTES);
    }

    public static byte[] form() {
        return CPCL.toBytes("FORM\n");
    }

    public static byte[] print() {
        return CPCL.toBytes("PRINT\n");
    }

    public static byte[] formPrint() {
        return CPCL.merge(CPCL.form(), CPCL.print());
    }

    static byte[] toBytes(String s) {
        return s.getBytes(StandardCharsets.UTF_8);
    }

    private static byte[] merge(byte[] ... bytes) {
        if (bytes == null) {
            return null;
        }
        if (bytes.length == 1) {
            return bytes[0];
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        for (byte[] aByte : bytes) {
            if (aByte == null) continue;
            baos.write(aByte, 0, aByte.length);
        }
        return baos.toByteArray();
    }

    static class ImageUtils {
        ImageUtils() {
        }

        public static int byteWidth(int width) {
            return (width + 7) / 8;
        }

        public static byte[] image2Bitmap(BufferedImage image) {
            ByteArrayOutputStream bitmapHex = new ByteArrayOutputStream();
            int w = image.getWidth();
            int h = image.getHeight();
            int byteWidth = ImageUtils.byteWidth(w);
            for (int i = 0; i < h; ++i) {
                for (int j = 0; j < byteWidth; ++j) {
                    int bin = 0;
                    for (int k = 0; k < 8; ++k) {
                        int x = j * 8 + k;
                        bin <<= 1;
                        if (x >= w) continue;
                        int rgb = image.getRGB(x, i);
                        bin += ImageUtils.rgb2Bin(rgb);
                    }
                    bitmapHex.write(bin);
                }
            }
            try {
                bitmapHex.flush();
                bitmapHex.close();
            }
            catch (IOException e) {
                log.error((Throwable)e);
            }
            return bitmapHex.toByteArray();
        }

        private static int rgb2Bin(int rgb) {
            int r = (rgb & 0xFF0000) >> 16;
            int g = (rgb & 0xFF00) >> 8;
            int b = rgb & 0xFF;
            int grey = r * 38 + g * 75 + b * 15 >> 7;
            return grey > 127 ? 0 : 1;
        }

        public static BufferedImage readImage(String filename) {
            try {
                BufferedImage image = ImageIO.read(new File(filename));
                if (image.getType() != 1 || image.getType() != 2) {
                    BufferedImage bimage = new BufferedImage(image.getWidth(), image.getHeight(), 1);
                    Graphics2D bGr = bimage.createGraphics();
                    bGr.drawImage((Image)image, 0, 0, null);
                    bGr.dispose();
                    return bimage;
                }
                return image;
            }
            catch (IOException e) {
                log.error((Throwable)e);
                return new BufferedImage(10, 10, 1);
            }
        }
    }
}

