/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.label.cpcl;

import java.awt.Point;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.print.core.label.cpcl.CPCL;

public class CpclBuilder {
    private static final Log log = LogFactory.getLog(CpclBuilder.class);
    private ByteArrayOutputStream baos = new ByteArrayOutputStream();

    public CpclBuilder createArea(int offset, int dpi, int height, int qty) {
        return this.area(offset, dpi, height, qty);
    }

    public CpclBuilder createArea(int offset, int dpi, int width, int height, int qty) {
        return this.createArea(offset, dpi, height, qty).pageWidth(width);
    }

    public CpclBuilder cut(int h) {
        return this.append(CPCL.cut(h));
    }

    public CpclBuilder cut(int h, int time) {
        return this.append(CPCL.cut(h, time));
    }

    public CpclBuilder area(int offset, int height, int qty) {
        return this.append(CPCL.area(offset, height, qty));
    }

    public CpclBuilder area(int offset, int dpi, int height, int qty) {
        return this.append(CPCL.area(offset, dpi, height, qty));
    }

    public CpclBuilder pageWidth(int width) {
        return this.append(CPCL.pageWidth(width));
    }

    public CpclBuilder density(int density) {
        return this.append(CPCL.density(density));
    }

    public CpclBuilder text(int font, int fontSize, int x, int y, String data) {
        return this.append(CPCL.text(font, fontSize, x, y, data));
    }

    public CpclBuilder text(int degree, int font, int fontSize, int x, int y, String data) {
        return this.append(CPCL.text(degree, font, fontSize, x, y, data));
    }

    public CpclBuilder text(int wordSpace, boolean underline, int degree, int font, int fontSize, int x, int y, String data) {
        if (underline) {
            this.append("UNDERLINE ON\n");
        }
        this.appendWordSpace(wordSpace).append(CPCL.text(degree, font, fontSize, x, y, data)).appendWordSpace(0);
        if (underline) {
            this.append("UNDERLINE OFF\n");
        }
        return this;
    }

    private CpclBuilder appendWordSpace(int wordSpace) {
        return this.append("SETSP " + wordSpace + "\n");
    }

    public CpclBuilder line(Point fromPoint, Point toPoint, int width) {
        return this.append(CPCL.line(fromPoint, toPoint, width));
    }

    public CpclBuilder line(int x0, int y0, int x1, int y1, int width) {
        return this.append(CPCL.line(x0, y0, x1, y1, width));
    }

    public CpclBuilder barCode(boolean isH, String type, int width, int ratio, int height, int x, int y, String data) {
        return this.append(CPCL.barCode(isH, type, width, ratio, height, x, y, data));
    }

    public CpclBuilder barCodeText(boolean on, int fontNumber, int fontSize, int offset) {
        return this.append(CPCL.barCodeText(on, fontNumber, fontSize, offset));
    }

    public CpclBuilder qrCode(String ecc, int x, int y, int m, int u, String data) {
        return this.append(CPCL.qrCode(ecc, x, y, m, u, data));
    }

    public CpclBuilder imageCG(int x, int y, String filename) {
        return this.append(CPCL.imageCG(x, y, filename));
    }

    public CpclBuilder imageCG(int x, int y, BufferedImage image) {
        return this.append(CPCL.imageCG(x, y, image));
    }

    public CpclBuilder imageEG(int x, int y, String filename) {
        return this.append(CPCL.imageEG(x, y, filename));
    }

    public CpclBuilder imageEG(int x, int y, BufferedImage image) {
        return this.append(CPCL.imageEG(x, y, image));
    }

    public CpclBuilder imageGG(int x, int y, String filename) {
        return this.append(CPCL.imageGG(x, y, filename));
    }

    public CpclBuilder imageGG(int x, int y, int maxSize, String filename) {
        return this.append(CPCL.imageGG(x, y, maxSize, filename));
    }

    public CpclBuilder imageGG(int x, int y, BufferedImage image) {
        return this.append(CPCL.imageGG(x, y, image));
    }

    public CpclBuilder imageGG(int x, int y, int maxSize, BufferedImage image) {
        return this.append(CPCL.imageGG(x, y, maxSize, image));
    }

    public CpclBuilder form() {
        return this.append(CPCL.form());
    }

    public CpclBuilder print() {
        return this.append(CPCL.print());
    }

    public CpclBuilder formPrint() {
        return this.append(CPCL.formPrint());
    }

    public CpclBuilder append(String str) {
        return this.append(CPCL.toBytes(str));
    }

    public CpclBuilder append(byte[] bytes) {
        this.baos.write(bytes, 0, bytes.length);
        return this;
    }

    public byte[] build() {
        return this.baos.toByteArray();
    }

    public String getCpclCmd() {
        try {
            return this.baos.toString("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            log.error((Throwable)e);
            return "";
        }
    }

    public void release() throws IOException {
        this.baos.close();
    }
}

