/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.model.designer;

import java.awt.Image;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.print.core.ctrl.reportone.r1.common.designercore.element.ICompositeObject;
import kd.bos.print.core.ctrl.reportone.r1.print.common.ImageUtil;
import kd.bos.print.core.model.designer.AbstractR1Page;
import kd.bos.print.core.model.designer.common.IReportObject;

public class R1PrintPage
extends AbstractR1Page {
    private static final Log log = LogFactory.getLog(R1PrintPage.class);
    private byte[] imageContent;
    private Image img = null;
    private int pictureOffSetX;
    private int pictureOffSetY;
    private boolean isConsultPageField = true;
    private boolean isHeightSyncFromPaperField = true;
    private int footerHeight;

    public R1PrintPage() {
        this.setLocked(true);
    }

    public final int getPictureOffSetX() {
        return this.pictureOffSetX;
    }

    public final void setPictureOffSetX(int offSetX) {
        this.pictureOffSetX = offSetX;
    }

    public final int getPictureOffSetY() {
        return this.pictureOffSetY;
    }

    public final void setPictureOffSetY(int offSetY) {
        this.pictureOffSetY = offSetY;
    }

    public final boolean isConsultPage() {
        return this.isConsultPageField;
    }

    public final void setConsultPage(boolean isConsultPage) {
        this.isConsultPageField = isConsultPage;
    }

    @Override
    public int getFooterHeight() {
        return this.footerHeight;
    }

    @Override
    public void setFooterHeight(int height) {
        this.footerHeight = height;
    }

    @Override
    public String getType() {
        return "Page";
    }

    public String[] getPropertyPanelKeys(ICompositeObject co) {
        return null;
    }

    public void setImageContent(byte[] imageBytes) {
        this.imageContent = imageBytes;
        this.img = imageBytes == null ? null : ImageUtil.makeImage(imageBytes);
    }

    public byte[] getImageContent() {
        return this.imageContent;
    }

    public final Image getImg() {
        return this.img;
    }

    public boolean isWidthSyncFromPaper() {
        return true;
    }

    public void setWidthSyncFromPaper(boolean is) {
    }

    public boolean isHeightSyncFromPaper() {
        return this.isHeightSyncFromPaperField;
    }

    public void setHeightSyncFromPaper(boolean is) {
        this.isHeightSyncFromPaperField = is;
    }

    public boolean[] checkChildrenOutside(int width, int height) {
        boolean[] result = new boolean[2];
        for (IReportObject ro : this.getChildren()) {
            if (ro.getXLom() + ro.getWidthLom() > width) {
                result[0] = true;
            }
            if (ro.getYLom() + ro.getHeightLom() <= height) continue;
            result[1] = true;
        }
        return result;
    }
}

