/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.model.designer.common;

import java.awt.Point;
import java.awt.Rectangle;
import kd.bos.print.core.ctrl.reportone.r1.common.designercore.util.Util;
import kd.bos.print.core.model.designer.common.AbstractElement;
import kd.bos.print.core.model.designer.common.IReportObject;
import kd.bos.util.StringUtils;

public abstract class AbstractReportObject
extends AbstractElement
implements IReportObject {
    protected int widthLom;
    protected int heightLom;
    private int xLom;
    private int yLom;
    private boolean isLockedField;
    private boolean isHorizontalFillField = false;
    private boolean isVerticalFillField = false;
    private boolean isPrintField;
    private boolean isDisabledField;
    private String printAtPage;

    @Override
    public int getXLom() {
        return this.xLom;
    }

    @Override
    public void setXLom(int x) {
        if (x != this.xLom) {
            int old = this.xLom;
            this.xLom = x;
            this.firePropertyChange("xLom", old, x);
        }
    }

    @Override
    public int getYLom() {
        return this.yLom;
    }

    @Override
    public void setYLom(int y) {
        if (y != this.yLom) {
            int old = this.yLom;
            this.yLom = y;
            this.firePropertyChange("yLom", old, y);
        }
    }

    @Override
    public int getHeightLom() {
        return this.heightLom;
    }

    @Override
    public void setHeightLom(int height) {
        if (height != this.heightLom) {
            int old = this.heightLom;
            this.heightLom = height;
            this.firePropertyChange("heightLom", old, height);
        }
    }

    @Override
    public int getWidthLom() {
        return this.widthLom;
    }

    @Override
    public void setWidthLom(int width) {
        if (width != this.widthLom) {
            int old = this.widthLom;
            this.widthLom = width;
            this.firePropertyChange("widthLom", old, width);
        }
    }

    @Override
    public String getPrintAtPage() {
        if (StringUtils.isBlank((String)this.printAtPage)) {
            return "nature";
        }
        return this.printAtPage;
    }

    @Override
    public void setPrintAtPage(String printAtPage) {
        this.printAtPage = printAtPage;
    }

    @Override
    public boolean isHorizontalFill() {
        return this.isHorizontalFillField;
    }

    @Override
    public void setHorizontalFill(boolean value) {
        this.isHorizontalFillField = value;
    }

    @Override
    public boolean isVerticalFill() {
        return this.isVerticalFillField;
    }

    @Override
    public void setVerticalFill(boolean value) {
        this.isVerticalFillField = value;
    }

    @Override
    public boolean isHorizontalResizable() {
        return true;
    }

    @Override
    public boolean isVerticalResizable() {
        return true;
    }

    @Override
    public boolean isLocked() {
        return this.isLockedField;
    }

    @Override
    public void setLocked(boolean locked) {
        this.isLockedField = locked;
    }

    public int getX() {
        return Util.lom2Pixel(this.getXLom());
    }

    public int getY() {
        return Util.lom2Pixel(this.getYLom());
    }

    public int getWidth() {
        return Util.lom2Pixel(this.getWidthLom());
    }

    public int getHeight() {
        return Util.lom2Pixel(this.getHeightLom());
    }

    @Override
    public boolean isPointInside(Point ptAtPage, int ext) {
        Rectangle rect = this.getRectAtPage();
        rect.translate(-ext, -ext);
        rect.width += ext * 2;
        rect.height += ext * 2;
        return rect.intersects(new Rectangle(ptAtPage.x, ptAtPage.y, 1, 1));
    }

    @Override
    public Rectangle getRectAtPage() {
        return new Rectangle();
    }

    @Override
    public void setPrint(boolean value) {
        this.isPrintField = value;
    }

    @Override
    public boolean isPrint() {
        return this.isPrintField;
    }

    @Override
    public void setDisabled(boolean value) {
        this.isDisabledField = value;
    }

    @Override
    public boolean isDisabled() {
        return this.isDisabledField;
    }

    @Override
    public void afterAdjusted() {
    }
}

