/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.model.designer.grid;

import java.util.ArrayList;
import kd.bos.print.core.ctrl.reportone.r1.common.designercore.element.grid.IGridsFactory;
import kd.bos.print.core.ctrl.reportone.r1.common.designercore.util.Util;
import kd.bos.print.core.model.designer.common.AbstractElement;
import kd.bos.print.core.model.designer.grid.AbstractCell;

public abstract class AbstractRow
extends AbstractElement {
    private ArrayList _cells;
    private int _height;
    private boolean isExtRowField = false;

    protected abstract IGridsFactory getGridsFactory();

    public AbstractRow(int size) {
        this._cells = new ArrayList(size);
        for (int i = 0; i < size; ++i) {
            this.addCell();
        }
    }

    protected AbstractCell getCreatedCell() {
        return this.getGridsFactory().createCell();
    }

    AbstractCell addCell() {
        AbstractCell cell = this.getCreatedCell();
        return this.addCell(this._cells.size(), cell);
    }

    AbstractCell insertCell(int cellIndex) {
        AbstractCell cell = this.getGridsFactory().createCell();
        return this.addCell(cellIndex, cell);
    }

    private AbstractCell addCell(int cellIndex, AbstractCell cell) {
        if (cellIndex < 0 || cellIndex > this._cells.size()) {
            return null;
        }
        this._cells.add(cellIndex, cell);
        return cell;
    }

    AbstractCell removeCell(int cellIndex) {
        if (cellIndex < 0 || cellIndex >= this._cells.size()) {
            return null;
        }
        return (AbstractCell)this._cells.remove(cellIndex);
    }

    public AbstractCell getCell(int cellIndex) {
        if (cellIndex < 0 || cellIndex >= this._cells.size()) {
            return null;
        }
        return (AbstractCell)this._cells.get(cellIndex);
    }

    public int getCellCount() {
        return this._cells.size();
    }

    public ArrayList getCells() {
        return this._cells;
    }

    public void setHeightLom(int h) {
        this._height = h;
    }

    public int getHeightLom() {
        return this._height;
    }

    public boolean isExtRow() {
        return this.isExtRowField;
    }

    public void setExtRow(boolean isExtRow) {
        this.isExtRowField = isExtRow;
    }

    public int getFeatHeight() {
        int h = Util.lom2Pixel(this._height);
        return h < 2 ? 2 : h;
    }

    public String getIdPrefix() {
        return "row";
    }
}

