/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.model.designer.grid.datagrid;

import java.util.ArrayList;
import java.util.List;
import kd.bos.print.core.ctrl.reportone.r1.common.designercore.element.grid.IGridsFactory;
import kd.bos.print.core.model.IDatasourceSupport;
import kd.bos.print.core.model.designer.grid.AbstractGrid;
import kd.bos.print.core.model.designer.grid.AbstractRow;
import kd.bos.print.core.model.designer.grid.datagrid.DataGridFactory;
import kd.bos.print.core.model.designer.grid.tabletail.ITableTailModel;
import kd.bos.print.core.model.designer.grid.tabletail.TableTail;

public class DataGrid
extends AbstractGrid
implements IDatasourceSupport,
ITableTailModel {
    private boolean isSubGridField = false;
    private boolean fixedRowAtPage;
    private int fixedRowCount;
    private boolean autoAdjustHeight;
    private boolean normalRowEveryPage;
    private boolean statRowEveryPage;
    private String datasource;
    private List<DataGrid> subDataGrids;
    private String subGridDirection;
    private TableTail tableTail;
    private boolean statWithData;
    private boolean hideEmptyMove;
    private boolean mergePrint;

    @Override
    public void setDatasource(String ds) {
        this.datasource = ds;
    }

    @Override
    public String getDatasource() {
        return this.datasource;
    }

    public boolean isNormalRowEveryPage() {
        return this.normalRowEveryPage;
    }

    public void setNormalRowEveryPage(boolean normalRowEveryPage) {
        this.normalRowEveryPage = normalRowEveryPage;
    }

    public boolean isStatRowEveryPage() {
        return this.statRowEveryPage;
    }

    public void setStatRowEveryPage(boolean statRowEveryPage) {
        this.statRowEveryPage = statRowEveryPage;
    }

    public boolean isFixedRowAtPage() {
        return this.fixedRowAtPage;
    }

    public void setFixedRowAtPage(boolean fixedRowAtPage) {
        this.fixedRowAtPage = fixedRowAtPage;
    }

    public int getFixedRowCount() {
        return this.fixedRowCount;
    }

    public void setFixedRowCount(int fixedRowCount) {
        this.fixedRowCount = fixedRowCount;
    }

    public boolean isAutoAdjustHeight() {
        return this.autoAdjustHeight;
    }

    public void setAutoAdjustHeight(boolean autoAdjustHeight) {
        this.autoAdjustHeight = autoAdjustHeight;
    }

    public boolean isSubGrid() {
        return this.isSubGridField;
    }

    public void setSubGrid(boolean isSubGrid) {
        this.isSubGridField = isSubGrid;
    }

    public DataGrid() {
        this.setPrint(true);
    }

    @Override
    public String getType() {
        return "DataGrid";
    }

    @Override
    public int getHeightLom() {
        return super.getHeightLom();
    }

    @Override
    public int getFeatHeight() {
        return this.addRowHeight(0, this.getRowsCount());
    }

    private int addRowHeight(int fromIdx, int toIdx) {
        int h = 0;
        for (int i = fromIdx; i < toIdx; ++i) {
            AbstractRow row = this.getRow(i);
            h += row.getFeatHeight() * this.getRowDrawingTimes(row);
        }
        return h;
    }

    @Override
    protected IGridsFactory getGridsFactory() {
        return DataGridFactory.getPrintDataGridFactory();
    }

    public List<DataGrid> getSubDataGrids() {
        return this.subDataGrids;
    }

    public void addSubDataGrid(DataGrid subDataGrid) {
        if (this.subDataGrids == null) {
            this.subDataGrids = new ArrayList<DataGrid>();
        }
        this.subDataGrids.add(subDataGrid);
    }

    public String getSubGridDirection() {
        return this.subGridDirection;
    }

    public void setSubGridDirection(String subGridDirection) {
        this.subGridDirection = subGridDirection;
    }

    @Override
    public TableTail getTableTail() {
        return this.tableTail;
    }

    @Override
    public void setTableTail(TableTail tableTail) {
        this.tableTail = tableTail;
    }

    public boolean isStatWithData() {
        return this.statWithData;
    }

    public void setStatWithData(boolean statWithData) {
        this.statWithData = statWithData;
    }

    public boolean isHideEmptyMove() {
        return this.hideEmptyMove;
    }

    public void setHideEmptyMove(boolean hideEmptyMove) {
        this.hideEmptyMove = hideEmptyMove;
    }

    public boolean isMergePrint() {
        return this.mergePrint;
    }

    public void setMergePrint(boolean mergePrint) {
        this.mergePrint = mergePrint;
    }
}

