/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.model.ui.component;

import java.util.ArrayList;
import kd.bos.print.core.ctrl.print.util.KPrintUtil;
import kd.bos.print.core.model.ui.component.LabelCell;
import kd.bos.print.core.model.ui.component.PainterInfo;
import kd.bos.print.core.model.ui.view.MixVariantLabelView;

public class MixVariantLabelCell
extends LabelCell {
    private ArrayList strList;

    @Override
    public void setText(String text) {
        super.setText(text);
        this.strList = text == null ? null : KPrintUtil.parseVariantText(text);
    }

    @Override
    public String getParserText(PainterInfo info) {
        if (this.strList == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        int size = this.strList.size();
        for (int i = 0; i < size; ++i) {
            String str = (String)this.strList.get(i);
            if (str == null) continue;
            int len = str.length();
            if (len > 2 && str.charAt(0) == '&' && str.charAt(1) == '[') {
                String temp = KPrintUtil.parseVariant(info, str.substring(2));
                if (temp == null) continue;
                sb.append(temp);
                continue;
            }
            sb.append(str);
        }
        return sb.toString();
    }

    @Override
    public void updateView() {
        this.setPainterView(MixVariantLabelView.createPainterView());
    }
}

