/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.model.ui.component;

import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfGraphics2D;
import com.lowagie.text.pdf.PdfTemplate;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.function.Function;
import kd.bos.print.core.ctrl.kdf.util.style.Rect;
import kd.bos.print.core.ctrl.kdf.util.style.Style;
import kd.bos.print.core.ctrl.kdf.util.style.StyleUtil;
import kd.bos.print.core.ctrl.kdf.util.style.Styles;
import kd.bos.print.core.ctrl.print.util.KPrintUtil;
import kd.bos.print.core.ctrl.reportone.r1.print.common.R1PrintInfo;
import kd.bos.print.core.execute.render.painter.IPainter;
import kd.bos.print.core.execute.render.painter.PaintContext;
import kd.bos.print.core.execute.render.painter.PaintPaperInfo;
import kd.bos.print.core.execute.render.painter.PainterFactory;
import kd.bos.print.core.model.ui.component.PainterCell;
import kd.bos.print.core.model.ui.component.PainterInfo;
import kd.bos.print.core.model.widget.AbstractPrintWidget;

public class PWCellPainter
extends PainterCell {
    private int parentX;
    private int parentY;
    protected AbstractPrintWidget printWidget;
    private PaintContext context;
    private PaintPaperInfo paintPaperInfo;
    private Function<AbstractPrintWidget, Point> correctPoint = null;

    public PWCellPainter(AbstractPrintWidget widget) {
        this.printWidget = widget;
    }

    public void setCorrectPoint(Function<AbstractPrintWidget, Point> correctPoint) {
        this.correctPoint = correctPoint;
    }

    public void setParentX(int parentX) {
        this.parentX = parentX;
    }

    public void setParentY(int parentY) {
        this.parentY = parentY;
    }

    public void setWidget(AbstractPrintWidget widget) {
        this.printWidget = widget;
    }

    public void setContext(PaintContext context) {
        this.context = context;
    }

    public void setPaintPaperInfo(PaintPaperInfo paintPaperInfo) {
        this.paintPaperInfo = paintPaperInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void painting(Graphics g, PainterInfo info) {
        Point point;
        AbstractPrintWidget widget = (AbstractPrintWidget)this.printWidget.copy();
        widget.setOutputValue(this.printWidget.getOutputValue());
        Rectangle rectangle = widget.getRectangle();
        if (this.correctPoint != null && (point = this.correctPoint.apply(this.printWidget)) != null) {
            this.parentX = point.x;
            this.parentY = point.y;
        }
        rectangle.x += this.parentX;
        rectangle.y += this.parentY;
        Style style = widget.getStyle();
        Rect padding = style.getPadding();
        long left = padding.getLeft();
        long right = padding.getRight();
        long top = padding.getTop();
        long bottom = padding.getBottom();
        long leftB = style.getBorderLineStyle(Styles.Position.LEFT).getWidth();
        long rightB = style.getBorderLineStyle(Styles.Position.RIGHT).getWidth();
        long topB = style.getBorderLineStyle(Styles.Position.TOP).getWidth();
        long bottomB = style.getBorderLineStyle(Styles.Position.BOTTOM).getWidth();
        rectangle.x = (int)((long)rectangle.x + StyleUtil.pixelToLom(left + leftB + 1L));
        rectangle.y = (int)((long)rectangle.y + StyleUtil.pixelToLom(top + topB + 1L));
        rectangle.width = (int)((long)rectangle.width - StyleUtil.pixelToLom(left + leftB + right + rightB + 1L));
        rectangle.height = (int)((long)rectangle.height - StyleUtil.pixelToLom(top + topB + bottom + bottomB + 1L));
        IPainter painter = PainterFactory.get().getPainter(widget);
        painter.addPaintObj(widget);
        painter.setPaintContext(this.context);
        painter.setPaperInfo(this.paintPaperInfo);
        float translateX = (float)KPrintUtil.lomToPrintPoint(this.parentX);
        float translateY = (float)KPrintUtil.lomToPrintPoint(this.parentY);
        PdfGraphics2D graphics2D = (PdfGraphics2D)g;
        try {
            R1PrintInfo r1PrintInfo = this.paintPaperInfo.getR1PrintInfo();
            Dimension paperDim = r1PrintInfo.getPaperSize();
            float widthPt = (float)StyleUtil.lomToPt(paperDim.width);
            float heightPt = (float)StyleUtil.lomToPt(paperDim.height);
            PdfContentByte content = graphics2D.getContent();
            PdfTemplate template = content.createTemplate(widthPt, heightPt);
            content.addTemplate(template, 0.0f, 0.0f);
            graphics2D.translate((double)(-translateX), (double)(-translateY));
            painter.paint(g, template);
        }
        finally {
            graphics2D.translate((double)translateX, (double)translateY);
        }
    }

    public AbstractPrintWidget getPrintWidget() {
        return this.printWidget;
    }
}

