/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.model.ui.component;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.List;
import javax.swing.SwingUtilities;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.print.core.ctrl.print.util.ImageFillUtil;
import kd.bos.print.core.model.ui.component.BasicPainter;
import kd.bos.print.core.model.ui.component.Canvas;
import kd.bos.print.core.model.ui.component.IPainter;
import kd.bos.print.core.model.ui.component.MixVariantLabelCell;
import kd.bos.print.core.model.ui.component.Page;
import kd.bos.print.core.model.ui.component.PainterInfo;

public class Paper
extends Canvas
implements Cloneable {
    private Canvas header;
    private Page body;
    private Canvas footer;
    private MixVariantLabelCell waterMark;
    private Image backGroundImage;
    private byte backGroundImageFillMode = (byte)3;
    private int paperIndex = -1;
    private short paperType = 1;
    private boolean isDynamicPaper;
    private static final int CENTERALIGN_HORIZONTAL = 1;
    private static final int CENTERALIGN_VERTICAL = 2;
    private static final int CENTERALIGN_CENTER = 3;
    private static final int CENTERALIGN_DEFAULT = 0;

    public Paper() {
    }

    public Paper(int index) {
        this.paperIndex = index;
    }

    protected Paper(short newValue) {
        this.paperType = newValue;
    }

    @Override
    public void updateView() {
    }

    @Override
    public void painting(Graphics g, PainterInfo info) {
        this.paintBackGround(g, info);
        this.paintBody(g, info);
        this.paintWaterMark(g, info);
    }

    private void paintBackGround(Graphics g, PainterInfo info) {
        Graphics2D g2d = (Graphics2D)g;
        Color color = this.getBackGround();
        if (color != null) {
            Color oldColor = g.getColor();
            g.setColor(color);
            ((Graphics2D)g).fill(this.getPainterBounds());
            g.setColor(oldColor);
        }
        if (this.backGroundImage != null) {
            Rectangle2D.Float rect = this.getPainterBounds();
            ImageFillUtil.draw(g2d, this.backGroundImage, rect, this.backGroundImageFillMode);
        }
    }

    private void paintBody(Graphics g, PainterInfo info) {
        Graphics2D g2d = (Graphics2D)g;
        Canvas header = this.getHeader();
        this.paintCanavs(g2d, header, info);
        Canvas footer = this.getFooter();
        this.paintCanavs(g2d, footer, info);
        Page bodypage = this.getBody();
        if (bodypage == null) {
            throw new KDException(new ErrorCode("print-exception", ResManager.loadKDString((String)"paper \u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"Paper_0", (String)"bos-print-core", (Object[])new Object[0])), new Object[0]);
        }
        PainterInfo pInfo = null;
        pInfo = bodypage.getPainterInfo();
        if (pInfo == null) {
            pInfo = info;
        }
        this.paintCanavs(g2d, bodypage, pInfo);
    }

    private void paintWaterMark(Graphics g, PainterInfo info) {
        if (this.waterMark == null) {
            return;
        }
        Rectangle2D.Float rect = this.getPainterBounds();
        String text = this.waterMark.getParserText(info);
        if (text == null || "".equals(text)) {
            return;
        }
        Graphics2D g2d = (Graphics2D)g;
        Font font = this.waterMark.getStyle().getFont();
        Rectangle2D fontRect = font.getStringBounds(text, g2d.getFontRenderContext());
        int strwidth = (int)(fontRect.getWidth() + 2.5);
        int strHeight = (int)(fontRect.getHeight() + 0.5);
        int rotation = this.waterMark.getStyle().getRotation();
        float width = strwidth;
        float height = strHeight;
        if (Math.abs(rotation) > 0) {
            width = this.widthWhenRotation(strwidth, rotation) + this.heightWhenRotation(strHeight, rotation);
            height = this.heightWhenRotation(strwidth, rotation) + this.widthWhenRotation(strHeight, rotation);
        }
        this.waterMark.setPainterBounds((rect.width - width) / 2.0f, (rect.height - height) / 2.0f, width, height);
        this.paintCanavs((Graphics2D)g, this.waterMark, info);
    }

    private float widthWhenRotation(float width, int rotation) {
        return (float)((double)width * Math.cos(Math.toRadians(Math.abs(rotation))));
    }

    private float heightWhenRotation(float width, int rotation) {
        return (float)((double)width * Math.sin(Math.toRadians(Math.abs(rotation))));
    }

    private void paintCanavs(Graphics2D g2d, IPainter canvas, PainterInfo info) {
        if (canvas == null) {
            return;
        }
        Graphics2D g = (Graphics2D)g2d.create();
        Rectangle2D.Float bounds = canvas.getPainterBounds();
        bounds.width = (float)((double)bounds.width * info.getScaleX());
        bounds.height = (float)((double)bounds.height * info.getScaleY());
        Rectangle clipBounds = g.getClipBounds();
        Rectangle canvasBounds = new Rectangle((int)bounds.x - 3, (int)bounds.y - 3, (int)bounds.width + 4, (int)bounds.height + 4);
        Rectangle resultClip = SwingUtilities.computeIntersection(clipBounds.x, clipBounds.y, clipBounds.width, clipBounds.height, canvasBounds);
        g.setClip(resultClip);
        Point2D.Float p = canvas.getPainterLocation();
        g.translate(p.x, p.y);
        if (info.getScaleX() != 1.0 || info.getScaleY() != 1.0) {
            g.scale(info.getScaleX(), info.getScaleY());
        }
        canvas.painting(g, info);
        if (info.getScaleX() != 1.0 || info.getScaleY() != 1.0) {
            g.scale(1.0 / info.getScaleX(), 1.0 / info.getScaleY());
        }
        g.translate(-p.x, -p.y);
        g.dispose();
    }

    public void setIndex(int index) {
        this.paperIndex = index;
    }

    public int getIndex() {
        return this.paperIndex;
    }

    public void setBody(Page thePage) {
        this.body = thePage;
    }

    public Page getBody() {
        return this.body;
    }

    public short getPaperType() {
        return this.paperType;
    }

    @Override
    public void setPainterInfo(PainterInfo printPainterInfo) {
        super.setPainterInfo(printPainterInfo);
        printPainterInfo.setPaperIndex(this.getIndex());
    }

    public void setWaterMark(MixVariantLabelCell waterMark) {
        this.waterMark = waterMark;
    }

    public void setBackGroundImage(Image backImage) {
        this.backGroundImage = backImage;
    }

    public void setBackGroundImageFillMode(byte mode) {
        this.backGroundImageFillMode = mode;
    }

    public void setHeader(Canvas head) {
        this.header = head;
    }

    public void setFooter(Canvas foot) {
        this.footer = foot;
    }

    public Canvas getHeader() {
        return this.header;
    }

    public Canvas getFooter() {
        return this.footer;
    }

    @Override
    public float getContentHeight() {
        List children = this.body.getAllPainter();
        float height = 1.0f;
        int size = children.size();
        for (int i = 0; i < size; ++i) {
            BasicPainter p = (BasicPainter)children.get(i);
            float theY = p.y + p.height;
            if (!(theY > height)) continue;
            height = theY + 1.0f;
        }
        return height;
    }

    public <IPrintJob> IPrintJob getPrintJob() {
        return (IPrintJob)this.getPainterInfo().invokeGet("getPrintJob");
    }

    public boolean isDynamicPaper() {
        return this.isDynamicPaper;
    }

    public void setDynamicPaper(boolean dynamicPaper) {
        this.isDynamicPaper = dynamicPaper;
    }
}

