/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.model.ui.view;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.util.Map;
import kd.bos.print.core.ctrl.print.util.KPrintUtil;
import kd.bos.print.core.model.ui.component.BarCodeCell;
import kd.bos.print.core.model.ui.component.IPainter;
import kd.bos.print.core.model.ui.component.PainterInfo;
import kd.bos.print.core.model.ui.view.BasicPainterView;
import kd.bos.print.core.model.widget.barcode.BarcodeUtils;

public class BarcodeCellView
extends BasicPainterView {
    public static BasicPainterView createPainterView() {
        return new BarcodeCellView();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(Graphics g, IPainter painter, PainterInfo graInfo) {
        BarCodeCell barcodeCell = (BarCodeCell)painter;
        Map config = barcodeCell.getConfig();
        if (config == null) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g;
        Integer rotate = (Integer)config.get("rotate");
        Rectangle2D.Float rc = painter.getPainterBounds();
        rc = (Rectangle2D.Float)rc.clone();
        if (rotate != null) {
            double xRotate = rc.getWidth() / 2.0;
            double yRotate = rc.getHeight() / 2.0;
            g2.rotate(Math.toRadians(rotate.intValue()), xRotate, yRotate);
        }
        super.paint(g, painter, graInfo);
        Integer barcodeDpi = (Integer)config.get("dpi");
        if (barcodeDpi == null) {
            barcodeDpi = 300;
        }
        double xDpis = barcodeDpi.intValue();
        double yDpis = barcodeDpi.intValue();
        double xScale = xDpis / (double)KPrintUtil.SCREEN_RESOLUTION;
        double yScale = yDpis / (double)KPrintUtil.SCREEN_RESOLUTION;
        g2.scale(1.0 / xScale, 1.0 / yScale);
        try {
            rc.width = (float)((double)rc.width * xScale);
            rc.height = (float)((double)rc.height * yScale);
            this.drawBarcode(g2, config, rc);
        }
        finally {
            g2.scale(xScale, yScale);
        }
    }

    private void drawBarcode(Graphics g, Map config, Rectangle2D.Float rc) {
        BarcodeUtils.paintBarcode(g, BarcodeCellView.floor(rc.getWidth()), BarcodeCellView.floor(rc.getHeight()), config);
    }

    private static int floor(Double d) {
        return (int)Math.floor(d);
    }
}

