/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.model.ui.view;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.print.core.ExecuteService;
import kd.bos.print.core.ctrl.common.util.ScaleUtil;
import kd.bos.print.core.ctrl.kdf.util.style.Style;
import kd.bos.print.core.ctrl.kdf.util.style.Styles;
import kd.bos.print.core.ctrl.reportone.r1.print.common.ImageUtil;
import kd.bos.print.core.model.ui.component.IPainter;
import kd.bos.print.core.model.ui.component.ImageCell;
import kd.bos.print.core.model.ui.component.PainterInfo;
import kd.bos.print.core.model.ui.view.BasicPainterView;
import kd.bos.print.core.model.ui.view.StyleRender;

public class ImageCellView
extends BasicPainterView {
    protected static ImageCellView imageUI = new ImageCellView();

    public static BasicPainterView createPainterView() {
        return imageUI;
    }

    @Override
    public void paint(Graphics g, IPainter painter, PainterInfo graInfo) {
        super.paint(g, painter, graInfo);
        Rectangle2D.Float rc = painter.getPainterBounds();
        Style style = painter.getStyle();
        if (style == null) {
            style = Styles.getStyle(Styles.getEmptySA());
        }
        Rectangle rcContent = StyleRender.getContentBounds((int)rc.width, (int)rc.height, style);
        ImageCell imageCell = (ImageCell)painter;
        double zoom = this.zoomInRect(imageCell, rcContent);
        g = g.create();
        ((Graphics2D)g).scale(zoom, zoom);
        StyleRender.drawImange(imageCell.getImage(), rcContent, style, imageCell.getScale(), g);
    }

    private double zoomInRect(ImageCell imageCell, Rectangle targetRect) {
        int height;
        int width;
        Image image = this.getImage(imageCell);
        if (image == null) {
            width = (int)imageCell.getWidth();
            height = (int)imageCell.getHeight();
        } else {
            width = image.getWidth(null);
            height = image.getHeight(null);
        }
        Dimension srcSize = new Dimension(width, height);
        double zoom = ScaleUtil.makeScale(imageCell.getScale(), srcSize, targetRect);
        if (zoom != 1.0 && zoom > 0.0) {
            targetRect.setRect((double)targetRect.x / zoom, (double)targetRect.y / zoom, (double)targetRect.width / zoom, (double)targetRect.height / zoom);
        }
        return zoom;
    }

    private Image getImage(ImageCell imageCell) {
        Image image = imageCell.getImage();
        String imageKey = imageCell.getImageKey();
        if (image == null && StringUtils.isNotBlank((CharSequence)imageKey)) {
            byte[] imageBytes = ExecuteService.getAttachService().getImage(imageKey);
            image = ImageUtil.makeImage(imageBytes);
            imageCell.setImage(image);
        }
        return image;
    }
}

