/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.model.ui.view;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import kd.bos.print.core.ctrl.common.util.STConverter;
import kd.bos.print.core.ctrl.kdf.util.style.Style;
import kd.bos.print.core.ctrl.kdf.util.style.Styles;
import kd.bos.print.core.model.ui.component.IPainter;
import kd.bos.print.core.model.ui.component.IRender;
import kd.bos.print.core.model.ui.component.LabelCell;
import kd.bos.print.core.model.ui.component.PainterInfo;
import kd.bos.print.core.model.ui.view.BasicPainterView;
import kd.bos.print.core.model.ui.view.StyleRender;

public class LabelCellView
extends BasicPainterView {
    protected static LabelCellView labelUI = new LabelCellView();

    public static BasicPainterView createPainterView() {
        return labelUI;
    }

    @Override
    public void paint(Graphics g, IPainter painter, PainterInfo graInfo) {
        Rectangle2D.Float rc = painter.getPainterBounds();
        Color backColor = painter.getBackGround();
        if (backColor != null && !Color.white.equals(backColor) && backColor.getAlpha() == 255) {
            Color oldColor = g.getColor();
            g.setColor(backColor);
            ((Graphics2D)g).fill(new Rectangle2D.Float(0.0f, 0.0f, rc.width, rc.height));
            g.setColor(oldColor);
        }
        Style style = painter.getStyle();
        StyleRender.drawBorders(0.0f, 0.0f, rc.width, rc.height, style, g);
        if (style == null) {
            style = Styles.getDefaultStyle();
        }
        IRender render = painter.getRender();
        Rectangle rcContent = StyleRender.getContentBounds((int)rc.width, (int)rc.height, style);
        String text = ((LabelCell)painter).getParserText(graInfo);
        int encode = graInfo.getEncode();
        if (encode == 1) {
            text = STConverter.tc2sc(text);
        } else if (encode == 2) {
            text = STConverter.sc2tc(text);
        }
        boolean isBlackWhite = ((LabelCell)painter).isBlackWhite();
        StyleRender.setBlackWhite(isBlackWhite);
        if (render == null) {
            StyleRender.drawText(g, rcContent, text, style, ((LabelCell)painter).isKeepClip(), 0);
        } else {
            render.drawText(g, rcContent, ((LabelCell)painter).getParserText(graInfo), style, painter);
        }
    }
}

