/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.model.ui.view;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import kd.bos.print.core.ctrl.common.util.STConverter;
import kd.bos.print.core.ctrl.kdf.util.render.BorderRender;
import kd.bos.print.core.ctrl.kdf.util.render.CellBackgroundRender;
import kd.bos.print.core.ctrl.kdf.util.render.CellImageRender;
import kd.bos.print.core.ctrl.kdf.util.render.CellTextRender;
import kd.bos.print.core.ctrl.kdf.util.render.splitrectangle.SplitRectTextRender;
import kd.bos.print.core.ctrl.kdf.util.style.LineStyle;
import kd.bos.print.core.ctrl.kdf.util.style.Rect;
import kd.bos.print.core.ctrl.kdf.util.style.Style;
import kd.bos.print.core.ctrl.kdf.util.style.Styles;
import kd.bos.print.core.execute.ExecuteWorkFactory;

public class StyleRender {
    private static final BorderRender.BorderInfo borderInfo = new BorderRender.BorderInfo(15);

    public static void setBlackWhite(boolean isBlackWhite) {
        StyleRender.getCellBackRender().setBlackWhite(isBlackWhite);
        StyleRender.getCellTextRender().setBlackWhite(isBlackWhite);
        StyleRender.getBorderRender().setBlackWhite(isBlackWhite);
    }

    public static final void drawBorders(float x, float y, float w, float h, Style style, Graphics g) {
        if (style == null) {
            return;
        }
        StyleRender.getBorderRender().draw(g, new Rectangle2D.Float(x, y, w, h), borderInfo, style);
    }

    public static final void drawBorders2(float x, float y, float w, float h, Style style, Graphics g) {
        if (style == null) {
            return;
        }
        StyleRender.getBorderRender2().draw(g, new Rectangle2D.Float(x, y, w, h), borderInfo, style);
    }

    public static final void drawBackground(int x, int y, int w, int h, Style style, Graphics g) {
        if (style == null) {
            return;
        }
        StyleRender.getCellBackRender().draw(g, new Rectangle2D.Float(x, y, w, h), null, style);
    }

    public static final void drawText(Graphics g, Rectangle2D clip, String text, Style style, int encode) {
        StyleRender.drawText(g, clip, text, style, true, encode);
    }

    public static final void drawText(Graphics g, Rectangle2D clip, String text, Style style) {
        StyleRender.drawText(g, clip, text, style, true, 0);
    }

    public static final void drawText(Graphics g, Rectangle2D clip, String text, Style style, boolean isClipStr, int encode) {
        if (text == null || text.equals("")) {
            return;
        }
        StyleRender.getCellTextRender().setKeepClip(isClipStr);
        String theText = text;
        if (encode == 1) {
            theText = STConverter.tc2sc(text);
        } else if (encode == 2) {
            theText = STConverter.sc2tc(text);
        }
        StyleRender.getCellTextRender().draw(g, clip, theText, style);
    }

    public static final void drawLine(int x1, int y1, int x2, int y2, Style style, Graphics g) {
        if (style == null) {
            return;
        }
        LineStyle ls = style.getBorderLineStyle(Styles.Position.LEFT);
        if (ls.isNullBorder()) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g;
        Color clrBak = g2.getColor();
        g2.setColor(style.getBorderColor(Styles.Position.LEFT));
        Stroke stkBak = g2.getStroke();
        Stroke stk = style.getStroke(Styles.Position.LEFT);
        g2.setStroke(stk);
        g2.drawLine(x1, y1, x2, y2);
        g2.setStroke(stkBak);
        g2.setColor(clrBak);
    }

    public static final void drawImange(Image img, Rectangle clip, Style style, int scale, Graphics g) {
        if (style == null) {
            return;
        }
        try {
            StyleRender.getCellImageRender().setMode((short)scale);
        }
        catch (IllegalArgumentException ex) {
            StyleRender.getCellImageRender().setMode((short)0);
        }
        StyleRender.getCellImageRender().draw(g, clip, img, style);
    }

    public static final Rectangle getContentBounds(int w, int h, Style style) {
        Rect padding = style.getPadding();
        int left = padding.getLeft();
        int top = padding.getTop();
        int right = padding.getRight();
        int bottom = padding.getBottom();
        if (style != null) {
            left = style.getBorderLineStyle(Styles.Position.LEFT).getWidth() + left;
            top = style.getBorderLineStyle(Styles.Position.TOP).getWidth() + top;
            right = style.getBorderLineStyle(Styles.Position.RIGHT).getWidth() + right;
            bottom = style.getBorderLineStyle(Styles.Position.BOTTOM).getWidth() + bottom;
        }
        return new Rectangle(left, top, w - left - right, h - top - bottom);
    }

    @Deprecated
    public static void drawSplitRectText(Graphics2D g2d, Rectangle2D.Float borderRect, Object splitInfo) {
        StyleRender.getSplitRender().draw(g2d, borderRect, splitInfo, null);
    }

    public static SplitRectTextRender getSplitRender() {
        return ExecuteWorkFactory.get().getSplitRectTextRender();
    }

    public static BorderRender getBorderRender() {
        BorderRender borderRender = ExecuteWorkFactory.get().getBorderRender();
        borderRender.setUseInt(false);
        return borderRender;
    }

    public static BorderRender getBorderRender2() {
        BorderRender borderRender = ExecuteWorkFactory.get().getBorderRender();
        borderRender.setUseInt(true);
        return borderRender;
    }

    public static CellTextRender getCellTextRender() {
        return ExecuteWorkFactory.get().getCellTextRender();
    }

    public static CellBackgroundRender getCellBackRender() {
        return ExecuteWorkFactory.get().getCellBackgroundRender();
    }

    public static CellImageRender getCellImageRender() {
        return ExecuteWorkFactory.get().getCellImageRender();
    }
}

