/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.model.widget;

import java.awt.Rectangle;
import java.io.Serializable;
import java.util.List;
import javax.swing.tree.TreePath;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.print.core.ctrl.common.util.StringUtil;
import kd.bos.print.core.ctrl.kdf.util.style.Style;
import kd.bos.print.core.ctrl.kdf.util.style.StyleAttributes;
import kd.bos.print.core.ctrl.kdf.util.style.Styles;
import kd.bos.print.core.ctrl.reportone.r1.print.common.IR1PrintScriptable;
import kd.bos.print.core.ctrl.reportone.r1.print.engine.DelayVarProvider;
import kd.bos.print.core.ctrl.reportone.r1.print.engine.IWidgetExecuteHelper;
import kd.bos.print.core.ctrl.reportone.r1.print.engine.exception.R1PrintException;
import kd.bos.print.core.data.field.Field;
import kd.bos.print.core.execute.ExecuteContext;
import kd.bos.print.core.model.WidgetLayout;
import kd.bos.print.core.model.widget.ExtPropertyMap;
import kd.bos.print.core.model.widget.IPrintWidget;
import kd.bos.print.core.model.widget.PWPage;
import kd.bos.print.core.model.widget.PrintAtPage;
import kd.bos.print.core.model.widget.StyleAccess;
import kd.bos.print.core.model.widget.runner.IRunner;
import kd.bos.print.core.model.widget.runner.RelativeContext;
import kd.bos.print.core.model.widget.runner.RunnerFactory;

public abstract class AbstractPrintWidget
implements IPrintWidget,
IR1PrintScriptable,
Serializable {
    private static final Log log = LogFactory.getLog(AbstractPrintWidget.class);
    private static final long serialVersionUID = 490314967638124024L;
    protected transient ExecuteContext _executeContext;
    private int pageIndex;
    private boolean canvasWidget;
    private transient RelativeContext relativeContext;
    private int containerHeight;
    private int containerWidth;
    private int maxHeightToAdjust;
    private PrintAtPage printAtPage;
    private transient Style style;
    protected transient IWidgetExecuteHelper helper;
    private transient AbstractPrintWidget peer;
    private String type;
    private String id;
    private String key;
    private Rectangle rect;
    private boolean isHFillField;
    private boolean isVFillField;
    private boolean isPrintableField;
    private String preScript;
    private String script;
    private String lastScript;
    protected transient IWidgetExecuteHelper _executeHelper;
    private ExtPropertyMap extProperties;
    private transient StyleAccess styleAccess;
    private boolean hideMove = false;
    private int rowNumber = 1;

    @Override
    public IRunner getRunner() {
        return RunnerFactory.getRunner(this);
    }

    @Override
    public boolean isHideMove() {
        return this.hideMove;
    }

    @Override
    public void setHideMove(boolean hideMove) {
        this.hideMove = hideMove;
    }

    public WidgetLayout getLayout() {
        return WidgetLayout.None;
    }

    @Override
    public int getContainerHeight() {
        return this.containerHeight;
    }

    @Override
    public void setContainerHeight(int containerHeight) {
        this.containerHeight = containerHeight;
    }

    @Override
    public int getContainerWidth() {
        return this.containerWidth;
    }

    @Override
    public void setContainerWidth(int containerWidth) {
        this.containerWidth = containerWidth;
    }

    @Override
    public int getMaxHeightToAdjust() {
        return this.maxHeightToAdjust;
    }

    @Override
    public void setMaxHeightToAdjust(int maxHeightToAdjust) {
        this.maxHeightToAdjust = maxHeightToAdjust;
    }

    @Override
    public int getPageIndex() {
        return this.pageIndex;
    }

    @Override
    public void setPageIndex(int pageIndex) {
        this.pageIndex = pageIndex;
    }

    @Override
    public boolean isCanvasWidget() {
        return this.canvasWidget;
    }

    @Override
    public void setCanvasWidget(boolean canvasWidget) {
        this.canvasWidget = canvasWidget;
    }

    @Override
    public RelativeContext getRelativeContext() {
        return this.relativeContext;
    }

    @Override
    public void setRelativeContext(RelativeContext relativeContext) {
        this.relativeContext = relativeContext;
    }

    public PrintAtPage getPrintAtPage() {
        return this.printAtPage;
    }

    public void setPrintAtPage(PrintAtPage printAtPage) {
        this.printAtPage = printAtPage;
    }

    @Override
    public void beginOutput() {
        if (this.isCanvasWidget()) {
            this.getRelativeContext().recordPosition(this);
            this.getRelativeContext().scanRelative(this);
        }
    }

    @Override
    public void cacheOutput() {
        if (this.isCanvasWidget()) {
            this.getRelativeContext().cacheOutPutWidget(this);
        }
    }

    @Override
    public void endOutput() {
        if (this.isCanvasWidget()) {
            this.getRelativeContext().recordPosition(this);
        }
    }

    public ExtPropertyMap getExtProps() {
        if (this.extProperties == null) {
            this.extProperties = new ExtPropertyMap();
        }
        return this.extProperties;
    }

    @Override
    public void setType(String type) {
        this.type = type;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setKey(String key) {
        this.key = key;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public void setRectangle(Rectangle rect) {
        this.rect = rect;
    }

    @Override
    public Rectangle getRectangle() {
        return this.rect;
    }

    @Override
    public void setHFill(boolean isHorizontalFill) {
        this.isHFillField = isHorizontalFill;
    }

    @Override
    public boolean isHFill() {
        return this.isHFillField;
    }

    @Override
    public void setVFill(boolean isVerticalFill) {
        this.isVFillField = isVerticalFill;
    }

    @Override
    public boolean isVFill() {
        return this.isVFillField;
    }

    @Override
    public void setStyle(Style style) {
        this.style = style;
    }

    @Override
    public Style getStyle() {
        if (this.style == null) {
            Style style;
            StyleAttributes emptySA = Styles.getEmptySA();
            this.style = style = Styles.getStyle(emptySA);
            return style;
        }
        return this.style;
    }

    @Override
    public void setPrintable(boolean printable) {
        this.isPrintableField = printable;
    }

    @Override
    public boolean isPrintable() {
        return this.isPrintableField;
    }

    @Override
    public String getPreScript() {
        return this.preScript;
    }

    @Override
    public void setPreScript(String str) {
        this.preScript = str;
    }

    @Override
    public String getScript() {
        return this.script;
    }

    @Override
    public void setScript(String str) {
        this.script = str;
    }

    @Override
    public String getLastScript() {
        return this.lastScript;
    }

    @Override
    public void setLastScript(String str) {
        this.lastScript = str;
    }

    @Override
    public IPrintWidget copy() {
        AbstractPrintWidget output = null;
        try {
            output = (AbstractPrintWidget)this.getClass().newInstance();
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, new ErrorCode("print-exception", ResManager.loadKDString((String)"\u590d\u5236\u51fa\u9519\u3002", (String)"AbstractPrintWidget_0", (String)"bos-print-core", (Object[])new Object[0])), new Object[0]);
        }
        output.setId(this.getId());
        output.setKey(this.getKey());
        output.setType(this.getType());
        if (this.getRectangle() != null) {
            output.setRectangle(new Rectangle(this.getRectangle()));
        }
        output.setHFill(this.isHFill());
        output.setVFill(this.isVFill());
        output.setStyle(this.getStyle());
        output.setPrintable(this.isPrintable());
        output.setPreScript(this.getPreScript());
        output.setScript(this.getScript());
        output._executeContext = this._executeContext;
        output._executeHelper = this._executeHelper;
        output.extProperties = this.extProperties;
        output.styleAccess = this.styleAccess;
        output.peer = this;
        output.setRelativeContext(this.getRelativeContext());
        output.setPageIndex(this.getPageIndex());
        output.setContainerWidth(this.getContainerWidth());
        output.setContainerHeight(this.getContainerHeight());
        output.setMaxHeightToAdjust(this.getMaxHeightToAdjust());
        output.setCanvasWidget(this.isCanvasWidget());
        output.setPrintAtPage(this.getPrintAtPage());
        output.setHideMove(this.isHideMove());
        return output;
    }

    @Override
    public ExecuteContext getContext() {
        if (this._executeContext == null) {
            this._executeContext = new ExecuteContext();
        }
        return this._executeContext;
    }

    @Override
    public PWPage getOwnerOutputPage() {
        return null;
    }

    protected Object getFieldValue(String ds, String field) {
        IWidgetExecuteHelper.IDataHelper dataHelper = this.getDataHelper(this._executeHelper, ds);
        if (!dataHelper.isContextRelative() && StringUtil.isEmptyString(ds)) {
            return String.format(ResManager.loadKDString((String)"[%s\u672a\u7ed1\u5b9a\u6570\u636e\u6e90]", (String)"AbstractPrintWidget_1", (String)"bos-print-core", (Object[])new Object[0]), this.getId());
        }
        Field var = dataHelper.getFieldValue(ds, field);
        if (var != null) {
            return var.getValue();
        }
        return null;
    }

    @Override
    public StyleAccess getStyleAccess() {
        if (this.styleAccess == null) {
            this.styleAccess = new StyleAccess(this.getStyle());
        }
        return this.styleAccess;
    }

    @Override
    public void setProperty(String key, Object value) {
        this.getStyleAccess().set(key, value);
    }

    @Override
    public Object getProperty(String key) {
        return this.getStyleAccess().get(key);
    }

    @Override
    public Object getValue() {
        return null;
    }

    @Override
    public void setValue(Object value) {
    }

    @Override
    public boolean isHide() {
        return !this.isPrintable();
    }

    @Override
    public void setHide(boolean isHide) {
        this.setPrintable(!isHide);
    }

    @Override
    public Object getPageNumber() {
        return this.getPageIndex() + 1;
    }

    @Override
    public Object getPageTotal() {
        return DelayVarProvider.makeVarSign("pageTotal");
    }

    @Override
    public Object getFieldValue(String field) {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        sb.append(this.getId());
        sb.append(ResManager.loadKDString((String)"\u4e0d\u652f\u6301getFieldValue(String field)", (String)"AbstractPrintWidget_2", (String)"bos-print-core", (Object[])new Object[0]));
        return sb.toString();
    }

    public AbstractPrintWidget getPeer() {
        return this.peer;
    }

    public IWidgetExecuteHelper.IDataHelper getDataHelper(IWidgetExecuteHelper helper, String ds) {
        IWidgetExecuteHelper.IDataHelper dataHelper = helper.getDataHelper();
        return dataHelper;
    }

    @Override
    public void runLastScript() {
        String script = this.getLastScript();
        if (this._executeHelper != null && !StringUtil.isEmptyString(script)) {
            this._executeHelper.runScript(this, 3);
        }
    }

    @Deprecated
    public void recursionChildrenFill(boolean isDealHorizontal, int deltaHorizontal, boolean isDealVertical, int deltaVertical) {
    }

    @Override
    @Deprecated
    public IPrintWidget execute(IWidgetExecuteHelper helper) throws R1PrintException {
        return this;
    }

    @Deprecated
    protected void executing(IWidgetExecuteHelper helper, IPrintWidget outputWidget) throws R1PrintException {
    }

    @Deprecated
    protected void executChildren(List<IPrintWidget> childs) throws R1PrintException {
    }

    @Deprecated
    protected void doBeforeExecuteChildren(IPrintWidget output) {
    }

    @Override
    @Deprecated
    public void setMainDs(String ds) {
    }

    @Deprecated
    protected String getMainDs() {
        return null;
    }

    @Override
    @Deprecated
    public TreePath getOutputedParent() {
        return null;
    }

    @Override
    @Deprecated
    public void setDynamicDecimal(String field) {
    }

    public Object getRowNumber() {
        return this.rowNumber;
    }
}

