/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.model.widget;

import java.math.BigDecimal;
import java.math.BigInteger;
import kd.bos.entity.format.FormatFactory;
import kd.bos.entity.format.FormatObject;
import kd.bos.entity.format.FormatTypes;
import kd.bos.entity.format.NumberFormatObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.print.core.ExecuteContext;
import kd.bos.print.core.ctrl.kdf.util.render.r1print.DivideModel;
import kd.bos.print.core.ctrl.kdf.util.render.r1print.IDivideCharacterSupport;
import kd.bos.print.core.data.field.Field;
import kd.bos.print.core.model.widget.AbstractPrintWidgetField;
import kd.bos.print.core.model.widget.IPrintWidget;
import kd.bos.print.core.model.widget.IPrintWidgetText;
import kd.bos.print.core.model.widget.PWPage;
import kd.bos.print.core.model.widget.runner.RunnerFactory;

public abstract class AbstractPrintWidgetText
extends AbstractPrintWidgetField
implements IPrintWidgetText,
IDivideCharacterSupport {
    private static final Log log = LogFactory.getLog(AbstractPrintWidgetText.class);
    private Field outputValue;
    private String outputText;
    private boolean isAdjustHeight;
    private int maxHeightToAdjust;
    private transient DivideModel divideModel;
    private int divideCharNums;
    private boolean ignoreZero;
    private boolean ignoreTailZero;

    public boolean isAdjustHeight() {
        return this.isAdjustHeight;
    }

    public void setAdjustHeight(boolean adjustHeight) {
        this.isAdjustHeight = adjustHeight;
    }

    @Override
    public int getMaxHeightToAdjust() {
        return this.maxHeightToAdjust;
    }

    @Override
    public void setMaxHeightToAdjust(int maxHeightToAdjust) {
        this.maxHeightToAdjust = maxHeightToAdjust;
    }

    public boolean isIgnoreZero() {
        return this.ignoreZero;
    }

    public void setIgnoreZero(boolean ignoreZero) {
        this.ignoreZero = ignoreZero;
    }

    public boolean isIgnoreTailZero() {
        return this.ignoreTailZero;
    }

    public void setIgnoreTailZero(boolean ignoreTailZero) {
        this.ignoreTailZero = ignoreTailZero;
    }

    @Override
    public void setOutputValue(Field value) {
        this.outputValue = value;
    }

    @Override
    public Field getOutputValue() {
        return this.outputValue;
    }

    @Override
    public void setOutputText(String text) {
        this.outputText = text;
    }

    @Override
    public String getOutputText() {
        return this.outputText;
    }

    @Override
    public int getDivideCharNums() {
        return this.divideCharNums;
    }

    @Override
    public void setDivideCharNums(int divideCharNums) {
        this.divideCharNums = divideCharNums;
    }

    @Override
    public DivideModel getDivideModel() {
        if (this.divideModel == null) {
            this.divideModel = new DivideModel();
        }
        return this.divideModel;
    }

    @Override
    public void setDivideModel(DivideModel model) {
        this.divideModel = model;
    }

    @Override
    public IPrintWidget copy() {
        AbstractPrintWidgetText output = (AbstractPrintWidgetText)super.copy();
        output.setDatasource(this.getDatasource());
        output.setBindField(this.getBindField());
        output.setDivideCharNums(this.getDivideCharNums());
        output.setDivideModel(this.getDivideModel());
        output.setIgnoreTailZero(this.ignoreTailZero);
        output.setIgnoreZero(this.ignoreZero);
        return output;
    }

    @Override
    public Object getValue() {
        if (this.getOutputValue() != null) {
            return this.getOutputValue().getValue();
        }
        return null;
    }

    protected final boolean isContainsLastScript() {
        return this.getScript() != null && this.getScript().indexOf("//<RunAfterStat>") >= 0;
    }

    @Override
    public Object getPageTotal() {
        Object key = super.getPageTotal();
        RunnerFactory.getExistRunner(PWPage.class.getName() + "_" + ExecuteContext.get().isSplicePrint()).getWidgetHelper().getDelayVarProvider().markCell(key, this);
        return key;
    }

    protected String formatNumber(BigDecimal value, NumberFormatObject numberformatObj, boolean ignoreTailZero, int scale) {
        FormatObject formatObject = new FormatObject();
        if (ignoreTailZero) {
            value.stripTrailingZeros();
        }
        if (scale == -1) {
            scale = value.scale();
        }
        numberformatObj.setMinimumFractionDigits(scale);
        formatObject.setNumberFormat(numberformatObj);
        String num = FormatFactory.get((FormatTypes)FormatTypes.Number).getFormat(formatObject).format(value);
        return num;
    }

    protected BigDecimal toBigDecimal(Object value) {
        BigDecimal ret = BigDecimal.ZERO;
        if (value instanceof BigDecimal) {
            ret = (BigDecimal)value;
        } else if (value instanceof String) {
            try {
                ret = new BigDecimal((String)value);
            }
            catch (Exception exception) {}
        } else if (value instanceof BigInteger) {
            ret = new BigDecimal((BigInteger)value);
        } else if (value instanceof Number) {
            ret = BigDecimal.valueOf(((Number)value).doubleValue());
        }
        return ret;
    }

    @Override
    public Object getFieldValue(String field) {
        return this.getFieldValue(this.getDatasource(), field);
    }

    @Override
    @Deprecated
    public void setDynamicDecimal(String field) {
    }
}

