/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.model.widget;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.print.core.data.field.Field;
import kd.bos.print.core.data.field.MapField;
import kd.bos.print.core.model.designer.grid.MergeBlock;
import kd.bos.print.core.model.widget.AbstractPrintWidget;
import kd.bos.print.core.model.widget.AbstractPrintWidgetText;
import kd.bos.print.core.model.widget.IPrintWidget;
import kd.bos.print.core.model.widget.PWFooter;
import kd.bos.print.core.model.widget.PWPage;
import kd.bos.print.core.model.widget.barcode.PWBarcode;
import kd.bos.print.core.model.widget.grid.AbstractPWGrid;
import kd.bos.print.core.model.widget.grid.AbstractPWGridCell;
import kd.bos.print.core.model.widget.grid.AbstractPWGridRow;
import kd.bos.print.core.model.widget.grid.MergeType;
import kd.bos.print.core.model.widget.grid.datagrid.AbstractPWDataGridRow;
import kd.bos.print.core.model.widget.grid.datagrid.PWDataGrid;
import kd.bos.print.core.utils.PTuple;

public class PWidgetUtil {
    public static boolean isQRCode(IPrintWidget widget) {
        MapField mapField;
        Map value;
        String type;
        if (!(widget instanceof PWBarcode)) {
            return false;
        }
        PWBarcode pwBarcode = (PWBarcode)widget;
        Field outputValue = pwBarcode.getOutputValue();
        return outputValue instanceof MapField && "QR_CODE".equals(type = (String)(value = (Map)(mapField = (MapField)outputValue).getValue()).get("barcodeType"));
    }

    public static boolean isEmptyPage(PWPage pwPage) {
        List children = pwPage.getChildren();
        return children == null || children.isEmpty();
    }

    public static boolean isOnlyHeadFooterPage(PWPage pwPage) {
        List children = pwPage.getChildren();
        if (children == null || children.isEmpty()) {
            return false;
        }
        boolean flag = true;
        for (AbstractPrintWidget widget : children) {
            if (widget instanceof PWFooter) continue;
            flag = false;
        }
        return flag;
    }

    public static PTuple getHeaderFooterHeight(PWPage pwPage) {
        int headerHeight = 0;
        int footerHeight = 0;
        if (pwPage == null) {
            return new PTuple<Integer, Integer>(headerHeight, footerHeight);
        }
        List children = pwPage.getChildren();
        if (!CollectionUtils.isEmpty((Collection)children)) {
            for (AbstractPrintWidget widget : children) {
                if (!(widget instanceof PWFooter)) continue;
                if ("Header".equals(widget.getType())) {
                    headerHeight = widget.getRectangle().height;
                    continue;
                }
                footerHeight = widget.getRectangle().height;
            }
        }
        return new PTuple<Integer, Integer>(headerHeight, footerHeight);
    }

    public static AbstractPrintWidget findButtomWidget(PWPage pwPage) {
        List children = pwPage.getChildren();
        AbstractPrintWidget targetWidget = null;
        for (AbstractPrintWidget widget : children) {
            if (targetWidget == null) {
                targetWidget = widget;
                continue;
            }
            int curY2 = widget.getRectangle().y + PWidgetUtil.getWidgetHeight(widget);
            int tarY2 = targetWidget.getRectangle().y + PWidgetUtil.getWidgetHeight(targetWidget);
            if (tarY2 >= curY2) continue;
            targetWidget = widget;
        }
        return targetWidget;
    }

    private static int getWidgetHeight(AbstractPrintWidget widget) {
        if (widget instanceof AbstractPWGrid) {
            AbstractPWGrid pwGrid = (AbstractPWGrid)widget;
            List outputRows = pwGrid.getOutputRows();
            int rowHeight = 0;
            for (AbstractPWGridRow row : outputRows) {
                rowHeight += row.getHeight();
            }
            pwGrid.getRectangle().height = rowHeight;
            return rowHeight;
        }
        return widget.getRectangle().height;
    }

    public static AbstractPrintWidget findFooterPage(PWPage pwPage) {
        List children = pwPage.getChildren();
        AbstractPrintWidget targetWidget = null;
        for (AbstractPrintWidget widget : children) {
            if (!(widget instanceof PWFooter) || !"Footer".equals(widget.getType())) continue;
            targetWidget = widget;
            break;
        }
        return targetWidget;
    }

    public static AbstractPrintWidget widgetCopyWithOutputValue(AbstractPrintWidget srcWidget) {
        if (srcWidget == null) {
            return null;
        }
        AbstractPrintWidget copy = (AbstractPrintWidget)srcWidget.copy();
        copy.setOutputValue(srcWidget.getOutputValue());
        if (srcWidget instanceof AbstractPrintWidgetText && copy instanceof AbstractPrintWidgetText) {
            ((AbstractPrintWidgetText)copy).setOutputText(((AbstractPrintWidgetText)srcWidget).getOutputText());
        } else if (srcWidget instanceof AbstractPWGrid) {
            List outputRows = ((AbstractPWGrid)srcWidget).getOutputRows();
            for (Object outputRow : outputRows) {
                ((AbstractPWGrid)copy).outputRow((AbstractPWGridRow)outputRow);
            }
        }
        return copy;
    }

    public static int getGridHeight(PWDataGrid dataGrid) {
        int height = 0;
        for (AbstractPWDataGridRow outputRow : dataGrid.getOutputRows()) {
            height += outputRow.getHeight();
        }
        return height;
    }

    public static boolean isWholePagination(AbstractPWGridRow row) {
        MergeBlock firstBlock = null;
        int verticalCellCount = 0;
        int realCellCount = 0;
        for (int i = 0; i < row.getCellCount(); ++i) {
            Object c = row.getCell(i);
            if (c == null) continue;
            ++realCellCount;
            MergeBlock mergeBlock = null;
            if (((AbstractPWGridCell)c).getMergeType() != MergeType.None && (mergeBlock = ((AbstractPWGridCell)c).getMergeBlock()) != null && mergeBlock.isVerticalMerge()) {
                ++verticalCellCount;
            }
            if (i != 0) continue;
            firstBlock = mergeBlock;
        }
        int sameMergeCount = 0;
        if (verticalCellCount == realCellCount && firstBlock != null) {
            for (int i = 0; i < row.getCellCount(); ++i) {
                MergeBlock mergeBlock;
                Object cell = row.getCell(i);
                if (cell == null || (mergeBlock = ((AbstractPWGridCell)cell).getMergeBlock()) == null || firstBlock.getTop() != mergeBlock.getTop() || firstBlock.getBottom() != mergeBlock.getBottom()) continue;
                ++sameMergeCount;
            }
        }
        return sameMergeCount == realCellCount || verticalCellCount <= 0;
    }

    public static boolean hasStatRowEveryPage(PWDataGrid outputGrid) {
        if (outputGrid.getSubDataGrids() != null && !outputGrid.getSubDataGrids().isEmpty()) {
            return false;
        }
        if (outputGrid.isSubGrid()) {
            return false;
        }
        if (outputGrid.isStatRowEveryPage()) {
            return true;
        }
        int rowCount = outputGrid.getRowsCount();
        for (int index = 0; index < rowCount; ++index) {
            AbstractPWDataGridRow row = (AbstractPWDataGridRow)outputGrid.getRow(index);
            if (row.getRowType() != 3 || !row.isDisplayEveryPage()) continue;
            return true;
        }
        return false;
    }

    public static boolean hasTitleRowStatRowEveryPage(PWDataGrid outputGrid) {
        return PWidgetUtil.hasStatRowEveryPage(outputGrid) && outputGrid.isTitleRowEveryPage();
    }

    public static int noPageSumStatRowsHeight(PWDataGrid outputGrid) {
        if (outputGrid == null || outputGrid.getRowsCount() == 0) {
            return 0;
        }
        int statRowHeight = 0;
        for (int i = 0; i < outputGrid.getRowsCount(); ++i) {
            AbstractPWDataGridRow row = (AbstractPWDataGridRow)outputGrid.getRow(i);
            if (row == null || row.getRowType() != 3 || row.isDisplayEveryPage()) continue;
            statRowHeight += row.getHeight();
        }
        return statRowHeight;
    }
}

