/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.model.widget.barcode;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.Map;
import kd.bos.print.core.model.widget.barcode.painter.AdjustBaseLineTextPainter;
import kd.bos.print.core.model.widget.barcode.painter.BarcodeContext;
import kd.bos.print.core.model.widget.barcode.painter.BarcodePainter;
import kd.bos.print.core.model.widget.barcode.painter.BaseLineTextPainter;
import kd.bos.print.core.model.widget.barcode.painter.DataMatrixPainter;
import kd.bos.print.core.model.widget.barcode.painter.EAN128Encoder;
import kd.bos.print.core.model.widget.barcode.painter.EAN128TextPainter;
import kd.bos.print.core.model.widget.barcode.painter.EAN13TextPainter;
import kd.bos.print.core.model.widget.barcode.painter.EAN8TextPainter;
import kd.bos.print.core.model.widget.barcode.painter.GraphicsForBarcode;
import kd.bos.print.core.model.widget.barcode.painter.HeightCodedPainter;
import kd.bos.print.core.model.widget.barcode.painter.QRPainter;
import kd.bos.print.core.model.widget.barcode.painter.UPCATextPainter;
import kd.bos.print.core.model.widget.barcode.painter.UPCETextPainter;
import kd.bos.print.core.model.widget.barcode.painter.WideRatioPainter;
import kd.bos.print.core.model.widget.barcode.painter.WidthCodedPainter;
import org.apache.commons.lang3.StringUtils;
import org.jbarcode.encode.BarcodeEncoder;
import org.jbarcode.encode.CodabarEncoder;
import org.jbarcode.encode.Code11Encoder;
import org.jbarcode.encode.Code128Encoder;
import org.jbarcode.encode.Code39Encoder;
import org.jbarcode.encode.Code39ExtEncoder;
import org.jbarcode.encode.Code93Encoder;
import org.jbarcode.encode.Code93ExtEncoder;
import org.jbarcode.encode.EAN13Encoder;
import org.jbarcode.encode.EAN8Encoder;
import org.jbarcode.encode.Interleaved2of5Encoder;
import org.jbarcode.encode.MSIPlesseyEncoder;
import org.jbarcode.encode.PostNetEncoder;
import org.jbarcode.encode.Standard2of5Encoder;
import org.jbarcode.encode.UPCAEncoder;
import org.jbarcode.encode.UPCEEncoder;

public class BarcodeUtils {
    private static String CODE128 = "code128";
    private static String EAN128 = "ean-128";
    private static String CODE39 = "code39";
    private static String CODE11 = "code11";
    private static String CODE39EXT = "code39-ext";
    private static String CODE93 = "code93";
    private static String CODE93EXT = "code93-ext";
    private static String EAN13 = "ean-13";
    private static String EAN8 = "ean-8";
    private static String CODABAR = "codabar";
    private static String Interleaved2of5 = "itf";
    private static String MSI = "msi";
    private static String POSTNET = "postnet";
    private static String Standard2of5 = "standard2of5";
    private static String UPCA = "upc-a";
    private static String UPCE = "upc-e";
    private static String DATA_MATRIX = "DATA_MATRIX";
    private static String PDF417 = "PDF_417";
    public static final String QR = "QR_CODE";

    public static void paintBarcode(Graphics g, int width, int height, Map config) {
        String type = (String)config.get("barcodeType");
        String barcode = (String)config.get("barcode");
        Boolean autoMatch = (Boolean)config.get("autoMatch");
        Boolean isShowSample = (Boolean)config.get("showSample");
        Integer fontSize = (Integer)config.get("fontSize");
        Boolean showText = (Boolean)config.get("showText");
        Boolean hasLineStyle = Boolean.FALSE;
        if (config.containsKey("hasLineStyle")) {
            hasLineStyle = (Boolean)config.get("hasLineStyle");
        }
        if (StringUtils.isBlank((CharSequence)type)) {
            type = CODE128;
        } else {
            if (type.equals(DATA_MATRIX) || type.equals(PDF417)) {
                DataMatrixPainter matrixPainter = new DataMatrixPainter();
                matrixPainter.paint(g, width, height, config);
                return;
            }
            if (type.equals(QR)) {
                QRPainter qrPainter = new QRPainter();
                qrPainter.paint(g, width, height, config);
                return;
            }
        }
        BarcodeContext barcodeContext = new BarcodeContext();
        GraphicsForBarcode graphicsForBarcode = new GraphicsForBarcode((Graphics2D)g);
        if (hasLineStyle.booleanValue()) {
            float scaleRate = 0.98f;
            double dx = ((float)width - (float)width * scaleRate) / 2.0f;
            double dy = ((float)height - (float)height * scaleRate) / 2.0f;
            graphicsForBarcode.scale(scaleRate, scaleRate);
            graphicsForBarcode.translate(dx, dy);
        }
        barcodeContext.setGraphics(graphicsForBarcode);
        barcodeContext.setBarcodeType(type);
        barcodeContext.setBarCode(barcode);
        barcodeContext.setWidth(width);
        barcodeContext.setHeight(height);
        barcodeContext.setScale(autoMatch == null ? false : autoMatch);
        barcodeContext.setShowSample(isShowSample == null ? false : isShowSample);
        barcodeContext.setFontSize(fontSize == null ? barcodeContext.getFontSize() : fontSize.intValue());
        barcodeContext.setShowText(showText);
        if (type.equals(EAN8)) {
            BarcodeUtils.paintEAN8(barcodeContext, config);
        } else if (type.equals(EAN13)) {
            BarcodeUtils.paintEAN13(barcodeContext, config);
        } else if (type.equals(EAN128)) {
            BarcodeUtils.paintEAN128(barcodeContext, config);
        } else if (type.equals(CODE128)) {
            BarcodeUtils.paintCode128(barcodeContext, config);
        } else if (type.equals(CODE39)) {
            BarcodeUtils.paintCode39(barcodeContext, config);
        } else if (type.equals(CODE39EXT)) {
            BarcodeUtils.paintCode39Ext(barcodeContext, config);
        } else if (type.equals(CODE93)) {
            BarcodeUtils.paintCode93(barcodeContext, config);
        } else if (type.equals(CODE93EXT)) {
            BarcodeUtils.paintCode93Ext(barcodeContext, config);
        } else if (type.equals(CODE11)) {
            BarcodeUtils.paintCode11(barcodeContext, config);
        } else if (type.equals(CODABAR)) {
            BarcodeUtils.paintCodaBar(barcodeContext, config);
        } else if (type.equals(Interleaved2of5)) {
            BarcodeUtils.paintInterleaved2of5(barcodeContext, config);
        } else if (type.equals(MSI)) {
            BarcodeUtils.paintMSI(barcodeContext, config);
        } else if (type.equals(POSTNET)) {
            BarcodeUtils.paintPOSTNET(barcodeContext, config);
        } else if (type.equals(Standard2of5)) {
            BarcodeUtils.paintStandard2of5(barcodeContext, config);
        } else if (type.equals(UPCA)) {
            BarcodeUtils.paintUPCA(barcodeContext, config);
        } else if (type.equals(UPCE)) {
            BarcodeUtils.paintUPCE(barcodeContext, config);
        }
    }

    private static void paintEAN8(BarcodeContext barcodeContext, Map config) {
        BarcodePainter barcodePainter = new BarcodePainter((BarcodeEncoder)EAN8Encoder.getInstance(), new WidthCodedPainter(), new EAN8TextPainter());
        String barcode = barcodeContext.getBarCode();
        if (barcode.trim().length() == 8) {
            barcode = barcode.trim().substring(0, 7);
            barcodeContext.setBarCode(barcode);
        }
        barcodeContext.setChecksumDigits(true);
        barcodeContext.setShowChecksumDigits(true);
        barcodePainter.paint(barcodeContext);
    }

    private static void paintEAN13(BarcodeContext barcodeContext, Map config) {
        BarcodePainter barcodePainter = new BarcodePainter((BarcodeEncoder)EAN13Encoder.getInstance(), new WidthCodedPainter(), new EAN13TextPainter());
        String barcode = barcodeContext.getBarCode();
        if (barcode.trim().length() == 13) {
            barcodeContext.setChecksumDigits(false);
            barcodeContext.setShowChecksumDigits(false);
        } else {
            barcodeContext.setChecksumDigits(true);
            barcodeContext.setShowChecksumDigits(true);
        }
        barcodePainter.paint(barcodeContext);
    }

    private static void paintEAN128(BarcodeContext barcodeContext, Map config) {
        BarcodePainter barcodePainter = new BarcodePainter(EAN128Encoder.getInstance(), new WidthCodedPainter(), new EAN128TextPainter());
        barcodeContext.setChecksumDigits(false);
        barcodeContext.setShowChecksumDigits(false);
        barcodePainter.paint(barcodeContext);
    }

    private static void paintCode128(BarcodeContext barcodeContext, Map config) {
        BarcodePainter barcodePainter = new BarcodePainter((BarcodeEncoder)Code128Encoder.getInstance(), new WidthCodedPainter(), new AdjustBaseLineTextPainter());
        barcodeContext.setChecksumDigits(false);
        barcodeContext.setShowChecksumDigits(false);
        barcodePainter.paint(barcodeContext);
    }

    private static void paintCode39(BarcodeContext barcodeContext, Map config) {
        BarcodePainter barcodePainter = new BarcodePainter(Code39Encoder.getInstance(), new WideRatioPainter(), new AdjustBaseLineTextPainter());
        barcodeContext.setChecksumDigits(false);
        barcodeContext.setShowChecksumDigits(false);
        barcodePainter.paint(barcodeContext);
    }

    private static void paintCode39Ext(BarcodeContext barcodeContext, Map config) {
        BarcodePainter barcodePainter = new BarcodePainter(Code39ExtEncoder.getInstance(), new WideRatioPainter(), new BaseLineTextPainter());
        barcodeContext.setChecksumDigits(false);
        barcodeContext.setShowChecksumDigits(false);
        barcodePainter.paint(barcodeContext);
    }

    private static void paintCode93(BarcodeContext barcodeContext, Map config) {
        BarcodePainter barcodePainter = new BarcodePainter(Code93Encoder.getInstance(), new WidthCodedPainter(), new BaseLineTextPainter());
        barcodeContext.setChecksumDigits(true);
        barcodeContext.setShowChecksumDigits(false);
        barcodePainter.paint(barcodeContext);
    }

    private static void paintCode93Ext(BarcodeContext barcodeContext, Map config) {
        BarcodePainter barcodePainter = new BarcodePainter(Code93ExtEncoder.getInstance(), new WidthCodedPainter(), new AdjustBaseLineTextPainter());
        barcodeContext.setChecksumDigits(true);
        barcodeContext.setShowChecksumDigits(false);
        barcodePainter.paint(barcodeContext);
    }

    private static void paintCode11(BarcodeContext barcodeContext, Map config) {
        BarcodePainter barcodePainter = new BarcodePainter(Code11Encoder.getInstance(), new WidthCodedPainter(), new BaseLineTextPainter());
        barcodeContext.setShowText(true);
        barcodeContext.setChecksumDigits(true);
        barcodeContext.setShowChecksumDigits(true);
        barcodePainter.paint(barcodeContext);
    }

    private static void paintCodaBar(BarcodeContext barcodeContext, Map config) {
        BarcodePainter barcodePainter = new BarcodePainter((BarcodeEncoder)CodabarEncoder.getInstance(), new WidthCodedPainter(), new AdjustBaseLineTextPainter());
        barcodeContext.setShowText(true);
        barcodeContext.setChecksumDigits(true);
        barcodeContext.setShowChecksumDigits(true);
        barcodePainter.paint(barcodeContext);
    }

    private static void paintInterleaved2of5(BarcodeContext barcodeContext, Map config) {
        BarcodePainter barcodePainter = new BarcodePainter((BarcodeEncoder)Interleaved2of5Encoder.getInstance(), new WidthCodedPainter(), new BaseLineTextPainter());
        barcodeContext.setShowText(true);
        barcodeContext.setChecksumDigits(true);
        barcodeContext.setShowChecksumDigits(true);
        barcodePainter.paint(barcodeContext);
    }

    private static void paintStandard2of5(BarcodeContext barcodeContext, Map config) {
        BarcodePainter barcodePainter = new BarcodePainter((BarcodeEncoder)Standard2of5Encoder.getInstance(), new WidthCodedPainter(), new BaseLineTextPainter());
        barcodeContext.setShowText(true);
        barcodeContext.setChecksumDigits(true);
        barcodeContext.setShowChecksumDigits(true);
        barcodePainter.paint(barcodeContext);
    }

    private static void paintMSI(BarcodeContext barcodeContext, Map config) {
        BarcodePainter barcodePainter = new BarcodePainter(MSIPlesseyEncoder.getInstance(), new WidthCodedPainter(), new BaseLineTextPainter());
        barcodeContext.setShowText(true);
        barcodeContext.setChecksumDigits(true);
        barcodeContext.setShowChecksumDigits(true);
        barcodePainter.paint(barcodeContext);
    }

    private static void paintPOSTNET(BarcodeContext barcodeContext, Map config) {
        BarcodePainter barcodePainter = new BarcodePainter((BarcodeEncoder)PostNetEncoder.getInstance(), new HeightCodedPainter(), new BaseLineTextPainter());
        barcodeContext.setShowText(true);
        barcodeContext.setChecksumDigits(true);
        barcodeContext.setShowChecksumDigits(true);
        barcodePainter.paint(barcodeContext);
    }

    private static void paintUPCA(BarcodeContext barcodeContext, Map config) {
        BarcodePainter barcodePainter = new BarcodePainter((BarcodeEncoder)UPCAEncoder.getInstance(), new WidthCodedPainter(), new UPCATextPainter());
        barcodeContext.setShowText(true);
        barcodeContext.setChecksumDigits(true);
        barcodeContext.setShowChecksumDigits(true);
        barcodePainter.paint(barcodeContext);
    }

    private static void paintUPCE(BarcodeContext barcodeContext, Map config) {
        BarcodePainter barcodePainter = new BarcodePainter((BarcodeEncoder)UPCEEncoder.getInstance(), new WidthCodedPainter(), new UPCETextPainter());
        barcodeContext.setShowText(true);
        barcodeContext.setChecksumDigits(true);
        barcodeContext.setShowChecksumDigits(true);
        barcodePainter.paint(barcodeContext);
    }
}

