/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.model.widget.barcode;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.WriterException;
import com.google.zxing.common.BitMatrix;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class QRCodeUtils {
    private static final String BARCODE = "barcode";
    private static final String SUFFIX = "suffix";
    private static final String HEIGHT = "height";
    private static final String WIDTH = "width";
    private static final Log logger = LogFactory.getLog(QRCodeUtils.class);
    private static final int FRONT = -16777216;
    private static final int BACK = -1;
    private static final int MARGIN = 0;
    private static final String DEFAULT_CODE = "example";
    private static final String DEFAULT_SUFFIX = "png";
    private static final int DEFAULT_HEIGHT = 20;
    private static final int DEFAULT_WIDTH = 20;

    private QRCodeUtils() {
        throw new IllegalStateException("Utility class");
    }

    public static BufferedImage generateBarcodePicture(BarcodeFormat format, Map<String, Object> config) throws KDException {
        QRCodeUtils.checkConfigData(config);
        String barcode = (String)config.get(BARCODE);
        String suffix = (String)config.get(SUFFIX);
        int height = Integer.parseInt(config.get(HEIGHT).toString());
        int width = Integer.parseInt(config.get(WIDTH).toString());
        Object level = config.get("errorCorrectionLevel");
        if (ObjectUtils.isEmpty((Object)level)) {
            level = !"PDF_417".equalsIgnoreCase(format.name()) ? "L" : "auto";
        }
        HashMap<EncodeHintType, Object> hints = new HashMap<EncodeHintType, Object>(4);
        hints.put(EncodeHintType.CHARACTER_SET, "UTF-8");
        hints.put(EncodeHintType.MARGIN, 0);
        if (!"auto".equalsIgnoreCase(level.toString())) {
            hints.put(EncodeHintType.ERROR_CORRECTION, level);
        }
        BitMatrix bitMatrix = null;
        try {
            bitMatrix = new MultiFormatWriter().encode(barcode, format, width, height, hints);
        }
        catch (WriterException e) {
            logger.warn("bitMatrix encode fail!");
        }
        BufferedImage img = QRCodeUtils.toBufferedImage(bitMatrix);
        return img;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void generateBarcodePicture(OutputStream os, BarcodeFormat format, Map<String, Object> config) throws KDException {
        QRCodeUtils.checkConfigData(config);
        String barcode = (String)config.get(BARCODE);
        String suffix = (String)config.get(SUFFIX);
        int height = Integer.parseInt(config.get(HEIGHT).toString());
        int width = Integer.parseInt(config.get(WIDTH).toString());
        Object level = config.get("errorCorrectionLevel");
        if (ObjectUtils.isEmpty((Object)level)) {
            level = !"PDF_417".equalsIgnoreCase(format.name()) ? "L" : "auto";
        }
        HashMap<EncodeHintType, Object> hints = new HashMap<EncodeHintType, Object>(4);
        hints.put(EncodeHintType.CHARACTER_SET, "UTF-8");
        hints.put(EncodeHintType.MARGIN, 0);
        if (!"auto".equalsIgnoreCase(level.toString())) {
            hints.put(EncodeHintType.ERROR_CORRECTION, level);
        }
        BitMatrix bitMatrix = null;
        try {
            bitMatrix = new MultiFormatWriter().encode(barcode, format, width, height, hints);
        }
        catch (WriterException e) {
            logger.warn("bitMatrix encode fail!");
        }
        BufferedImage img = QRCodeUtils.toBufferedImage(bitMatrix);
        try {
            ImageIO.write((RenderedImage)img, suffix, os);
        }
        catch (IOException e) {
            logger.error("ImageIO write fail!");
        }
        finally {
            if (img != null) {
                img.getGraphics().dispose();
            }
        }
    }

    public static BufferedImage toBufferedImage(BitMatrix matrix) {
        if (matrix == null) {
            return null;
        }
        BufferedImage image = null;
        try {
            int[] rec = matrix.getEnclosingRectangle();
            int resWidth = rec[2] + 1;
            int resHeight = rec[3] + 1;
            image = new BufferedImage(resWidth, resHeight, 1);
            for (int i = 0; i < resWidth; ++i) {
                for (int j = 0; j < resHeight; ++j) {
                    if (matrix.get(i + rec[0], j + rec[1])) {
                        image.setRGB(i, j, -16777216);
                        continue;
                    }
                    image.setRGB(i, j, -1);
                }
            }
        }
        catch (Exception e) {
            logger.warn("\u4e8c\u7ef4\u7801\u53bb\u767d\u8fb9\u5f02\u5e38" + e.getMessage() + Arrays.toString(e.getStackTrace()));
            int width = matrix.getWidth();
            int height = matrix.getHeight();
            image = new BufferedImage(width, height, 1);
            for (int x = 0; x < width; ++x) {
                for (int y = 0; y < height; ++y) {
                    image.setRGB(x, y, matrix.get(x, y) ? -16777216 : -1);
                }
            }
        }
        return image;
    }

    private static void checkConfigData(Map<String, Object> config) {
        int height;
        String suffix;
        String barcode = (String)config.get(BARCODE);
        if (StringUtils.isEmpty((CharSequence)barcode)) {
            config.put(BARCODE, DEFAULT_CODE);
        }
        if (StringUtils.isEmpty((CharSequence)(suffix = (String)config.get(SUFFIX)))) {
            config.put(SUFFIX, DEFAULT_SUFFIX);
        }
        config.put(HEIGHT, (height = Integer.parseInt(config.get(HEIGHT).toString())) == 0 ? 20 : height);
        int width = Integer.parseInt(config.get(WIDTH).toString());
        config.put(WIDTH, height == 0 ? 20 : width);
    }
}

