/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.model.widget.barcode.ean128;

import kd.bos.print.core.exception.PrintException;
import kd.bos.print.core.model.widget.barcode.ean128.DefaultCode128Encoder;
import kd.bos.print.core.model.widget.barcode.ean128.EAN128AI;
import kd.bos.print.core.model.widget.barcode.ean128.EAN128BarSetHandler;

public class EAN128LogicImpl {
    private static final byte MAX_LENGTH = 48;
    private char groupSeparator = (char)29;
    private char checkDigitMarker = (char)240;
    private boolean omitBrackets = false;
    private String msgCache = null;
    private StringBuffer code128Msg = new StringBuffer(48);
    private StringBuffer humanReadableMsg = new StringBuffer(48);
    private int[] encodedMsg = new int[0];
    private PrintException exception = null;
    private boolean checksumADD = true;
    private boolean checksumCHECK = true;
    public static final char FNC_1 = '\u00f1';
    public static final char FNC_2 = '\u00f2';
    public static final char FNC_3 = '\u00f3';
    public static final char FNC_4 = '\u00f4';
    private static final byte[][] CHARSET = new byte[][]{{2, 1, 2, 2, 2, 2}, {2, 2, 2, 1, 2, 2}, {2, 2, 2, 2, 2, 1}, {1, 2, 1, 2, 2, 3}, {1, 2, 1, 3, 2, 2}, {1, 3, 1, 2, 2, 2}, {1, 2, 2, 2, 1, 3}, {1, 2, 2, 3, 1, 2}, {1, 3, 2, 2, 1, 2}, {2, 2, 1, 2, 1, 3}, {2, 2, 1, 3, 1, 2}, {2, 3, 1, 2, 1, 2}, {1, 1, 2, 2, 3, 2}, {1, 2, 2, 1, 3, 2}, {1, 2, 2, 2, 3, 1}, {1, 1, 3, 2, 2, 2}, {1, 2, 3, 1, 2, 2}, {1, 2, 3, 2, 2, 1}, {2, 2, 3, 2, 1, 1}, {2, 2, 1, 1, 3, 2}, {2, 2, 1, 2, 3, 1}, {2, 1, 3, 2, 1, 2}, {2, 2, 3, 1, 1, 2}, {3, 1, 2, 1, 3, 1}, {3, 1, 1, 2, 2, 2}, {3, 2, 1, 1, 2, 2}, {3, 2, 1, 2, 2, 1}, {3, 1, 2, 2, 1, 2}, {3, 2, 2, 1, 1, 2}, {3, 2, 2, 2, 1, 1}, {2, 1, 2, 1, 2, 3}, {2, 1, 2, 3, 2, 1}, {2, 3, 2, 1, 2, 1}, {1, 1, 1, 3, 2, 3}, {1, 3, 1, 1, 2, 3}, {1, 3, 1, 3, 2, 1}, {1, 1, 2, 3, 1, 3}, {1, 3, 2, 1, 1, 3}, {1, 3, 2, 3, 1, 1}, {2, 1, 1, 3, 1, 3}, {2, 3, 1, 1, 1, 3}, {2, 3, 1, 3, 1, 1}, {1, 1, 2, 1, 3, 3}, {1, 1, 2, 3, 3, 1}, {1, 3, 2, 1, 3, 1}, {1, 1, 3, 1, 2, 3}, {1, 1, 3, 3, 2, 1}, {1, 3, 3, 1, 2, 1}, {3, 1, 3, 1, 2, 1}, {2, 1, 1, 3, 3, 1}, {2, 3, 1, 1, 3, 1}, {2, 1, 3, 1, 1, 3}, {2, 1, 3, 3, 1, 1}, {2, 1, 3, 1, 3, 1}, {3, 1, 1, 1, 2, 3}, {3, 1, 1, 3, 2, 1}, {3, 3, 1, 1, 2, 1}, {3, 1, 2, 1, 1, 3}, {3, 1, 2, 3, 1, 1}, {3, 3, 2, 1, 1, 1}, {3, 1, 4, 1, 1, 1}, {2, 2, 1, 4, 1, 1}, {4, 3, 1, 1, 1, 1}, {1, 1, 1, 2, 2, 4}, {1, 1, 1, 4, 2, 2}, {1, 2, 1, 1, 2, 4}, {1, 2, 1, 4, 2, 1}, {1, 4, 1, 1, 2, 2}, {1, 4, 1, 2, 2, 1}, {1, 1, 2, 2, 1, 4}, {1, 1, 2, 4, 1, 2}, {1, 2, 2, 1, 1, 4}, {1, 2, 2, 4, 1, 1}, {1, 4, 2, 1, 1, 2}, {1, 4, 2, 2, 1, 1}, {2, 4, 1, 2, 1, 1}, {2, 2, 1, 1, 1, 4}, {4, 1, 3, 1, 1, 1}, {2, 4, 1, 1, 1, 2}, {1, 3, 4, 1, 1, 1}, {1, 1, 1, 2, 4, 2}, {1, 2, 1, 1, 4, 2}, {1, 2, 1, 2, 4, 1}, {1, 1, 4, 2, 1, 2}, {1, 2, 4, 1, 1, 2}, {1, 2, 4, 2, 1, 1}, {4, 1, 1, 2, 1, 2}, {4, 2, 1, 1, 1, 2}, {4, 2, 1, 2, 1, 1}, {2, 1, 2, 1, 4, 1}, {2, 1, 4, 1, 2, 1}, {4, 1, 2, 1, 2, 1}, {1, 1, 1, 1, 4, 3}, {1, 1, 1, 3, 4, 1}, {1, 3, 1, 1, 4, 1}, {1, 1, 4, 1, 1, 3}, {1, 1, 4, 3, 1, 1}, {4, 1, 1, 1, 1, 3}, {4, 1, 1, 3, 1, 1}, {1, 1, 3, 1, 4, 1}, {1, 1, 4, 1, 3, 1}, {3, 1, 1, 1, 4, 1}, {4, 1, 1, 1, 3, 1}, {2, 1, 1, 4, 1, 2}, {2, 1, 1, 2, 1, 4}, {2, 1, 1, 2, 3, 2}};
    private static final byte[] STOP = new byte[]{2, 3, 3, 1, 1, 1, 2};

    public EAN128LogicImpl() {
    }

    public EAN128LogicImpl(boolean checksumADD, boolean checksumCHECK, char fnc1) {
        this.checksumADD = checksumADD;
        this.checksumCHECK = checksumCHECK;
        this.groupSeparator = fnc1;
    }

    public void encodeChar(EAN128BarSetHandler handler, int index) {
        for (int i = 0; i < 6; i = (int)((byte)(i + 1))) {
            byte width = CHARSET[index][i];
            boolean black = i % 2 == 0;
            handler.addBar(black, width);
        }
        handler.endBarGroup();
    }

    public void encodeStop(EAN128BarSetHandler handler) {
        for (int i = 0; i < 7; i = (int)((byte)(i + 1))) {
            byte width = STOP[i];
            boolean black = i % 2 == 0;
            handler.addBar(black, width);
        }
        handler.endBarGroup();
    }

    protected void setMessage(String msg) {
        if (msg == null || !msg.equals(this.msgCache)) {
            this.code128Msg.setLength(0);
            this.humanReadableMsg.setLength(0);
            this.exception = null;
            if (msg == null) {
                this.msgCache = null;
            } else {
                this.msgCache = msg;
                this.code128Msg.append('\u00f1');
                this.addAIs(msg);
                DefaultCode128Encoder encoder = new DefaultCode128Encoder();
                this.encodedMsg = encoder.encode(this.getCode128Msg());
            }
        } else if (this.exception != null) {
            throw this.exception;
        }
    }

    public int[] getEncodedMessage(String msg) {
        this.setMessage(msg);
        return this.encodedMsg;
    }

    public void addAIs(String msg) {
        int offset = 0;
        boolean i = false;
        EAN128AI ai = null;
        while (offset < msg.length()) {
            offset = this.addAI(msg, offset, ai);
        }
    }

    private int findGroupSeparator(String msg, int start) {
        int retGS = msg.indexOf(this.groupSeparator, start);
        if (this.groupSeparator == '\u00f1') {
            return retGS;
        }
        int retF = msg.indexOf(241, start);
        if (retGS <= 0) {
            return retF;
        }
        if (retF <= 0) {
            return retGS;
        }
        return Math.min(retGS, retF);
    }

    public int addAI(String msg, int offset, EAN128AI ai) {
        if (msg == null) {
            throw this.getException("Message is empty!");
        }
        try {
            if (ai == null) {
                ai = EAN128AI.getAI(msg, offset);
            }
        }
        catch (Exception e) {
            throw this.getException(e.getMessage());
        }
        byte lenID = ai.lenID;
        byte lenMin = ai.lenMinAll;
        byte lenMax = ai.lenMaxAll;
        if (!this.omitBrackets) {
            this.humanReadableMsg.append('(');
        }
        this.humanReadableMsg.append(msg.substring(offset, offset + lenID));
        this.code128Msg.append(msg.substring(offset, offset + lenID));
        if (!this.omitBrackets) {
            this.humanReadableMsg.append(')');
        }
        boolean doChecksumADD = false;
        int[] startA = new int[ai.type.length + 1];
        startA[0] = offset;
        int newOffset = this.findGroupSeparator(msg, offset);
        if (newOffset < 0) {
            newOffset = msg.length();
        }
        if (newOffset < offset + lenID + lenMin) {
            if (this.checksumADD && ai.canDoChecksumADD && newOffset == offset + lenID + lenMin - 1) {
                doChecksumADD = true;
            } else {
                if ((ai.fixed || lenMin == lenMax) && newOffset < msg.length()) {
                    throw this.getException("FNC1 not allowed in fixed length field: \"" + msg.substring(offset + lenID, Math.min(msg.length(), offset + lenID + lenMax)) + "\"!");
                }
                throw this.getException("Field \"" + msg.substring(offset + lenID, newOffset) + "\" too short! Length should be " + lenMin + " at least!");
            }
        }
        if (newOffset > offset + lenID + lenMax) {
            if (ai.fixed || lenMin == lenMax) {
                newOffset = offset + lenID + lenMax;
            } else {
                throw this.getException("Variable length field \"" + msg.substring(offset + lenID, newOffset) + "\" too long! Length should be " + lenMax + " at the most!");
            }
        }
        int start = offset + lenID;
        for (byte i = 0; i < ai.type.length; i = (byte)(i + 1)) {
            startA[i + 1] = start;
            int end = ai.lenMin[i] == ai.lenMax[i] ? start + ai.lenMin[i] : newOffset - ai.minLenAfterVariableLen;
            if (doChecksumADD && i == ai.type.length - 1) {
                char c = this.calcCheckdigit(msg, startA[ai.checkDigitStart[i]], start, (byte)1);
                this.humanReadableMsg.append(c);
                this.code128Msg.append(c);
                if (newOffset < msg.length() && this.isGroupSeparator(msg.charAt(newOffset))) {
                    ++newOffset;
                }
            } else {
                this.checkType(ai, i, msg, start, end, startA[ai.checkDigitStart[i]]);
            }
            start = end;
        }
        if (newOffset < msg.length() && this.isGroupSeparator(msg.charAt(newOffset))) {
            ++newOffset;
        }
        if (!ai.fixed && newOffset < msg.length()) {
            this.code128Msg.append('\u00f1');
        }
        return newOffset;
    }

    private boolean isGroupSeparator(char ch) {
        return ch == this.groupSeparator || ch == '\u00f1';
    }

    private void checkType(EAN128AI ai, byte idx, String msg, int start, int end, int cdStart) {
        byte type = ai.type[idx];
        if (type == 4) {
            throw this.getException("This AI is not allowed by configuration! (" + ai.toString() + ")");
        }
        if (type == 2) {
            for (int i = end - 1; i >= start; --i) {
                if (msg.charAt(i) <= '\u0080' && !Character.isDigit(msg.charAt(i))) continue;
                throw this.getException("Character '" + msg.charAt(i) + "' must be a valid ASCII byte but not number!", msg.substring(start, i));
            }
        } else if (type == 0) {
            for (int i = end - 1; i >= start; --i) {
                if (msg.charAt(i) <= '\u0080') continue;
                throw this.getException("Character '" + msg.charAt(i) + "' must be a valid ASCII byte!", msg.substring(start, i));
            }
        } else {
            if (ai.isCheckDigit(idx) && this.checksumCHECK) {
                char cd1 = this.calcCheckdigit(msg, cdStart, start, (byte)1);
                char cd2 = msg.charAt(start);
                if (cd2 == this.checkDigitMarker) {
                    cd2 = cd1;
                }
                if (cd1 != cd2) {
                    throw this.getException("Checkdigit is wrong! Correct is " + cd1 + " but I found " + cd2 + "!");
                }
                this.humanReadableMsg.append(cd1);
                this.code128Msg.append(cd1);
                return;
            }
            for (int i = end - 1; i >= start; --i) {
                if (Character.isDigit(msg.charAt(i))) continue;
                throw this.getException("Character '" + msg.charAt(i) + "' must be a Digit!", msg.substring(start, i));
            }
            if (type == 3) {
                char cm1 = msg.charAt(start + 2);
                char cm2 = msg.charAt(start + 3);
                char cd1 = msg.charAt(start + 4);
                char cd2 = msg.charAt(start + 5);
                if (cm1 == '0' && cm2 == '0' || cm1 == '1' && cm2 > '2' || cm1 > '1') {
                    throw this.getException("Illegal Month \"" + cm1 + cm2 + "\"!", msg.substring(start, start + 2));
                }
                if (cd1 == '3' && cd2 > '1' || cd1 > '3') {
                    throw this.getException("Illegal Day \"" + cd1 + cd2 + "\"!", msg.substring(start, start + 4));
                }
            }
        }
        this.humanReadableMsg.append(msg, start, end);
        this.code128Msg.append(msg, start, end);
    }

    public char calcCheckdigit(String msg, int start, int end, byte type) {
        switch (type) {
            case 1: {
                return this.calcCheckdigit(3, 1, msg, start, end);
            }
            case 2: {
                return this.calcCheckdigit(1, 1, msg, start, end);
            }
        }
        return '0';
    }

    public char calcCheckdigit(int oddMult, int evenMult, String msg, int start, int end) {
        int oddSum = 0;
        int evenSum = 0;
        boolean even = false;
        for (int i = end - 1; i >= start; --i) {
            if (even) {
                evenSum += Character.digit(msg.charAt(i), 10);
            } else {
                oddSum += Character.digit(msg.charAt(i), 10);
            }
            even = !even;
        }
        int check = 10 - (evenMult * evenSum + oddMult * oddSum) % 10;
        if (check >= 10) {
            check = 0;
        }
        return Character.forDigit(check, 10);
    }

    private PrintException getException(String text) {
        return this.getException(text, "");
    }

    private PrintException getException(String text, String msgOk) {
        if (msgOk == null) {
            msgOk = "";
        }
        if (this.humanReadableMsg.length() > 1 || msgOk.length() > 0) {
            text = text + " Accepted start of Message: \"" + this.humanReadableMsg + msgOk + "\"";
        }
        this.exception = new PrintException("-1", text);
        return this.exception;
    }

    public String getCode128Msg() {
        return this.code128Msg.toString();
    }

    public String getHumanReadableMsg() {
        return this.humanReadableMsg.toString();
    }

    public String toString() {
        return this.getHumanReadableMsg();
    }
}

