/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.model.widget.barcode.painter;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import kd.bos.print.core.ExecuteService;
import kd.bos.print.core.ctrl.swing.KDFont;
import kd.bos.print.core.model.widget.barcode.painter.BarcodeContext;
import kd.bos.print.core.model.widget.barcode.painter.BaseTextPainter;
import kd.bos.print.core.model.widget.barcode.painter.GraphicsForBarcode;

public class AdjustBaseLineTextPainter
extends BaseTextPainter {
    @Override
    public void doPaint(BarcodeContext barcodeContext) {
        String text = barcodeContext.getText();
        double width = barcodeContext.getWidth();
        double height = barcodeContext.getHeight();
        double barWidth = barcodeContext.getBarWidth();
        int fontSize = barcodeContext.getFontSize();
        GraphicsForBarcode g = barcodeContext.getGraphics();
        int newFontSize = AdjustBaseLineTextPainter.round((double)fontSize * barWidth);
        if ((double)newFontSize > height * 0.35) {
            newFontSize = AdjustBaseLineTextPainter.round(height * 0.35);
        }
        String fontName = ExecuteService.getDefaultFont().getFontName();
        Font localFont = AdjustBaseLineTextPainter.createFont(fontName, newFontSize);
        g.setFont(localFont);
        FontMetrics fontMetrics = g.getFontMetrics();
        double rawStringWidth = fontMetrics.stringWidth(text);
        double fh = fontMetrics.getHeight();
        g.setColor(Color.WHITE);
        g.fillRect(0.0, 0.0, width, height * 0.05);
        g.fillRect(0.0, height - fh * 0.9, width, fh * 0.9);
        g.setColor(Color.BLACK);
        double totalBarsWidth = barcodeContext.getBarZoneWidth();
        double x = (width - rawStringWidth) / 2.0;
        double y = height - fh * 0.2;
        if (rawStringWidth >= totalBarsWidth * 0.8) {
            g.drawString(text, x, y);
        } else {
            double length = text.length();
            double gap = (totalBarsWidth * 0.8 - rawStringWidth) / (length - 1.0);
            x = (width - totalBarsWidth * 0.8) / 2.0;
            for (int k = 0; k < text.length(); ++k) {
                String s = text.substring(k, k + 1);
                g.drawString(s, x, y);
                double rawCharWidth = fontMetrics.charWidth(s.charAt(0));
                x += rawCharWidth + gap;
            }
        }
    }

    private static Font createFont(String fontName, float fontSize) {
        return KDFont.loadFontFromJAR(fontName, 0, fontSize);
    }

    private static int round(double d) {
        return (int)Math.round(d);
    }
}

