/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.model.widget.barcode.painter;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.RenderingHints;
import java.awt.Stroke;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.print.core.ExecuteService;
import kd.bos.print.core.model.widget.barcode.painter.BarPainter;
import kd.bos.print.core.model.widget.barcode.painter.BarcodeContext;
import kd.bos.print.core.model.widget.barcode.painter.EAN128Encoder;
import kd.bos.print.core.model.widget.barcode.painter.GraphicsForBarcode;
import kd.bos.print.core.model.widget.barcode.painter.MathUtils;
import kd.bos.print.core.model.widget.barcode.painter.TextPainter;
import org.jbarcode.encode.BarSet;
import org.jbarcode.encode.BarcodeEncoder;

public class BarcodePainter {
    private static final Log log = LogFactory.getLog(BarcodePainter.class);
    private BarcodeEncoder barcodeEncoder;
    private BarPainter barPainter;
    private TextPainter textPainter;

    public BarcodePainter(BarcodeEncoder barcodeEncoder, BarPainter barPainter, TextPainter textPainter) {
        this.barcodeEncoder = barcodeEncoder;
        this.barPainter = barPainter;
        this.textPainter = textPainter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(BarcodeContext barcodeContext) {
        String code = barcodeContext.getBarCode();
        if (code == null || code.trim().isEmpty()) {
            return;
        }
        GraphicsForBarcode g2d = barcodeContext.getGraphics();
        Font originalFont = g2d.getFont();
        Color originalColor = g2d.getColor();
        Color originalBackgroundColor = g2d.getBackground();
        Stroke originalStroke = g2d.getStroke();
        Object originalAntialising = g2d.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        try {
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            g2d.setStroke(new BasicStroke(1.0f, 2, 0));
            double width = barcodeContext.getWidth();
            double height = barcodeContext.getHeight();
            g2d.setColor(Color.WHITE);
            g2d.fillRect(0.0, 0.0, width, height);
            String codeToEncode = code;
            String codeToShow = code;
            if (barcodeContext.isChecksumDigits()) {
                codeToEncode = code + this.barcodeEncoder.computeCheckSum(code);
                if (barcodeContext.isShowChecksumDigits()) {
                    codeToShow = codeToEncode;
                }
            }
            barcodeContext.setScale(true);
            barcodeContext.setText(codeToShow);
            BarSet[] barSets = this.barcodeEncoder.encode(codeToEncode);
            if (this.barcodeEncoder instanceof EAN128Encoder) {
                barcodeContext.setText(((EAN128Encoder)this.barcodeEncoder).getCodeToShow());
            }
            barcodeContext.setBarSets(barSets);
            this.barPainter.paint(barcodeContext);
            if (barcodeContext.isShowText()) {
                this.textPainter.paint(barcodeContext);
            }
            if (!barcodeContext.isScale() && MathUtils.floor(barcodeContext.getBarWidth()) <= 0) {
                String warning = "print.barcode.tooSmall";
                GraphicsForBarcode g = barcodeContext.getGraphics();
                if (!warning.isEmpty()) {
                    int fontSize = (int)(width / 4.0);
                    String fontName = ExecuteService.getDefaultFont().getFontName();
                    Font font = new Font(fontName, 0, fontSize);
                    g.setColor(Color.BLACK);
                    g.setFont(font);
                    FontMetrics metrics = g.getFontMetrics();
                    int fontHeight = metrics.getHeight();
                    for (int i = 0; i < warning.length() / 4; ++i) {
                        int start = i * 4;
                        int end = start + 4;
                        end = end <= warning.length() ? end : warning.length();
                        g.drawString(warning.substring(start, end), 0.0, (double)(i * fontHeight) + width / 8.0);
                    }
                }
            }
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
        finally {
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, originalAntialising);
            g2d.setStroke(originalStroke);
            g2d.setBackground(originalBackgroundColor);
            g2d.setColor(originalColor);
            g2d.setFont(originalFont);
        }
    }
}

