/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.model.widget.barcode.painter;

import com.google.zxing.BarcodeFormat;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.io.ByteArrayOutputStream;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.print.core.execute.exporter.impl.R1PBarcode_W2V;
import kd.bos.print.core.model.widget.barcode.QRCodeUtils;
import kd.bos.print.core.model.widget.barcode.painter.GraphicsForBarcode;

public class DataMatrixPainter {
    private static final Log log = LogFactory.getLog(DataMatrixPainter.class);

    public void paint(Graphics g, int width, int height, Map config) {
        if (!(g instanceof Graphics2D)) {
            return;
        }
        GraphicsForBarcode g2 = new GraphicsForBarcode((Graphics2D)g);
        try {
            BarcodeFormat format = Enum.valueOf(BarcodeFormat.class, config.get("barcodeType").toString());
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            QRCodeUtils.generateBarcodePicture(os, format, config);
            byte[] bytes = os.toByteArray();
            boolean widthSmaller = width < height;
            double drawWidth = widthSmaller ? (double)width : (double)height;
            double x = 0.0;
            double y = 0.0;
            if (widthSmaller) {
                x = 0.0;
                y = (height - width) / 2;
            } else {
                x = (width - height) / 2;
                y = 0.0;
            }
            Image image = R1PBarcode_W2V.loadImage(bytes);
            g2.drawImage(image, 2.0, 5.0, (double)(width - 4), drawWidth, null);
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
    }
}

