/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.model.widget.barcode.painter;

import java.util.List;
import kd.bos.dataentity.Tuple;
import kd.bos.print.core.model.widget.barcode.ean128.EAN128BarSetHandler;
import kd.bos.print.core.model.widget.barcode.ean128.EAN128LogicImpl;
import org.jbarcode.encode.BarSet;

public class EAN128Utils {
    public static Tuple<BarSet[], String> encode(String code) {
        try {
            code = code.trim();
            InternalEAN128LogicImpl impl = new InternalEAN128LogicImpl();
            EAN128BarSetHandler handler = new EAN128BarSetHandler();
            impl.generateBarcodeLogic(handler, code);
            List<BarSet> barSets = handler.getBarSets();
            return Tuple.create((Object)barSets.toArray(new BarSet[0]), (Object)impl.getHumanReadableMsg());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String buildHumanReadableMsg(String code) {
        code = code.trim();
        InternalEAN128LogicImpl impl = new InternalEAN128LogicImpl();
        return impl.buildHumanReadableMsg(code);
    }

    private static class InternalEAN128LogicImpl
    extends EAN128LogicImpl {
        private static final char DEFAULT_GROUP_SEPARATOR = 'F';
        private static final char groupSeparator = 'F';

        public InternalEAN128LogicImpl() {
            super(true, true, 'F');
        }

        public void generateBarcodeLogic(EAN128BarSetHandler handler, String msg) {
            int[] encodedMsg;
            for (int j : encodedMsg = this.getEncodedMessage(msg)) {
                this.encodeChar(handler, j);
            }
            int checksum = encodedMsg[0];
            for (int i = 1; i < encodedMsg.length; ++i) {
                checksum += i * encodedMsg[i];
            }
            this.encodeChar(handler, checksum %= 103);
            this.encodeStop(handler);
        }

        public String buildHumanReadableMsg(String msg) {
            this.setMessage(msg);
            return this.getHumanReadableMsg();
        }
    }
}

