/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.model.widget.barcode.painter;

import com.google.zxing.BarcodeFormat;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.print.core.model.widget.barcode.QRCodeUtils;

public class QRPainter {
    private static final Log log = LogFactory.getLog(QRPainter.class);

    public void paint(Graphics g, int width, int height, Map config) {
        if (!(g instanceof Graphics2D)) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g;
        try {
            boolean widthSmaller = width < height;
            int drawWidth = widthSmaller ? width : height;
            config.put("suffix", "png");
            config.put("width", drawWidth);
            config.put("height", drawWidth);
            BarcodeFormat format = Enum.valueOf(BarcodeFormat.class, config.get("barcodeType").toString());
            BufferedImage image = QRCodeUtils.generateBarcodePicture(format, config);
            int x = 0;
            int y = 0;
            if (widthSmaller) {
                x = 0;
                y = (height - width) / 2;
            } else {
                x = (width - height) / 2;
                y = 0;
            }
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            if (image != null) {
                g2.drawImage(image.getScaledInstance(drawWidth - 2, drawWidth - 2, 4), x, y, null);
            }
        }
        catch (Exception e) {
            log.warn("\u4e8c\u7ef4\u7801\u7ed8\u5236\u5f02\u5e38" + e.getMessage() + Arrays.toString(e.getStackTrace()));
        }
    }
}

