/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.model.widget.barcode.painter;

import java.awt.Color;
import kd.bos.print.core.model.widget.barcode.painter.BarcodeContext;
import kd.bos.print.core.model.widget.barcode.painter.BaseBarPainter;
import kd.bos.print.core.model.widget.barcode.painter.GraphicsForBarcode;
import kd.bos.print.core.model.widget.barcode.painter.MathUtils;
import org.jbarcode.encode.BarSet;

public class WidthCodedPainter
extends BaseBarPainter {
    private static String CODE128 = "code128";
    private static String EAN128 = "ean-128";
    private static String CODE39 = "code39";
    private static String CODE11 = "code11";
    private static String CODE39EXT = "code39-ext";
    private static String CODE93 = "code93";
    private static String CODE93EXT = "code93-ext";
    private static String EAN13 = "ean-13";
    private static String EAN8 = "ean-8";
    private static String CODABAR = "codabar";
    private static String Interleaved2of5 = "intl2of5";
    private static String MSI = "msi";
    private static String POSTNET = "postnet";
    private static String Standard2of5 = "standard2of5";
    private static String UPCA = "upc-a";
    private static String UPCE = "upc-e";
    private static String DATA_MATRIX = "datamatrix";
    private static String PDF417 = "pdf417";
    private static String QR = "qr";
    private static String[] nonXPaddingBarcodeTypes = new String[]{CODE128, EAN128, CODE93, CODE93EXT, CODE11, CODABAR, Interleaved2of5, Standard2of5, MSI};

    @Override
    public void doPaint(BarcodeContext barcodeContext) {
        BarSet[] barSets = barcodeContext.getBarSets();
        double width = barcodeContext.getWidth();
        double height = barcodeContext.getHeight();
        int xPaddingBars = 10;
        if (!WidthCodedPainter.needXPaddings(barcodeContext)) {
            xPaddingBars = 1;
        }
        int totalBars = xPaddingBars * 2;
        for (int i = 0; i < barSets.length; ++i) {
            totalBars += barSets[i].length();
        }
        double barWidth = width / (double)totalBars;
        if (!barcodeContext.isScale()) {
            barWidth = MathUtils.floor(barWidth);
        }
        barcodeContext.setBarWidth(barWidth);
        double totalBarWidth = barWidth * (double)totalBars;
        barcodeContext.setBarZoneWidth(totalBarWidth);
        double barZoneHeight = height;
        barcodeContext.setBarZoneHeight(barZoneHeight);
        double barZoneStartX = (width - totalBarWidth) / 2.0;
        barcodeContext.setBarZoneStartX(barZoneStartX);
        double barPadding = (double)xPaddingBars * barWidth;
        barcodeContext.setBarPaddingX(barPadding);
        GraphicsForBarcode g = barcodeContext.getGraphics();
        g.setColor(Color.WHITE);
        g.fillRect(0.0, 0.0, width, height);
        double x = barZoneStartX + (double)xPaddingBars * barWidth;
        boolean prev = true;
        double groupWidth = 0.0;
        for (int i = 0; i < barSets.length; ++i) {
            BarSet barSet = barSets[i];
            for (int j = 0; j < barSet.length(); ++j) {
                boolean bit = barSet.get(j);
                if (bit == prev) {
                    groupWidth += barWidth;
                } else {
                    if (WidthCodedPainter.round(groupWidth) >= 1) {
                        g.setColor(prev ? Color.BLACK : Color.WHITE);
                        g.fillRect(x, 2.0, groupWidth, height - 4.0);
                    }
                    x += groupWidth;
                    groupWidth = barWidth;
                }
                prev = bit;
            }
        }
        if (WidthCodedPainter.round(groupWidth) >= 1) {
            g.setColor(prev ? Color.BLACK : Color.WHITE);
            g.fillRect(x, 2.0, groupWidth, height - 4.0);
        }
    }

    private static boolean needXPaddings(BarcodeContext barcodeContext) {
        String barcodeType = barcodeContext.getBarcodeType();
        for (String type : nonXPaddingBarcodeTypes) {
            if (!type.equals(barcodeContext.getBarcodeType())) continue;
            return false;
        }
        return true;
    }

    private static int round(double d) {
        return (int)Math.round(d);
    }
}

