/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.model.widget.grid;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.print.core.model.designer.grid.MergeBlock;
import kd.bos.print.core.model.widget.AbstractPrintWidget;
import kd.bos.print.core.model.widget.IPrintWidget;
import kd.bos.print.core.model.widget.PrintAtPage;
import kd.bos.print.core.model.widget.grid.AbstractPWGridColumn;
import kd.bos.print.core.model.widget.grid.AbstractPWGridRow;
import kd.bos.print.core.model.widget.grid.datagrid.context.GridExecuteContext;
import kd.bos.print.core.model.widget.grid.tabletail.ITableTailSupport;
import kd.bos.print.core.model.widget.grid.tabletail.PWTableTail;

public abstract class AbstractPWGrid<T extends AbstractPWGridRow, C extends AbstractPWGridColumn>
extends AbstractPrintWidget {
    protected ArrayList<T> rows = new ArrayList();
    protected ArrayList<C> columns = new ArrayList();
    protected ArrayList<T> outputRows = new ArrayList();
    protected ArrayList<C> outputColumns;
    private boolean notBlankRow;
    private String gridBorderType;
    private Map<String, MergeBlock> mergeBlocks = new HashMap<String, MergeBlock>();
    private boolean wholeRowPage;
    private boolean wholeGridPage;
    private boolean tempWholeRowPage;
    private boolean skipTitleEvery;

    public T addRow(int type) {
        return this.createRow(type, this.rows.size());
    }

    public T insertRow(int type, int rowIndex) {
        return this.createRow(type, rowIndex);
    }

    protected abstract T createRow(int var1, int var2);

    public void delRow(int rowIndex) {
        this.rows.remove(rowIndex);
        this.resetRowIndex();
    }

    protected void resetRowIndex() {
        for (int i = 0; i < this.getRowsCount(); ++i) {
            ((AbstractPWGridRow)this.rows.get(i)).setRowIndex(i);
        }
    }

    public int getRowsCount() {
        return this.rows.size();
    }

    public T getRow(int rowIndex) {
        AbstractPWGridRow row = (AbstractPWGridRow)this.rows.get(rowIndex);
        return (T)row;
    }

    public abstract C addColumn();

    public abstract C insertColumn(int var1);

    protected final C createColumn(int colIndex, C col) {
        this.columns.add(colIndex, col);
        int c = this.getRowsCount();
        for (int i = 0; i < c; ++i) {
            ((AbstractPWGridRow)this.getRow(i)).insertCell(colIndex);
        }
        return col;
    }

    public final void delColumn(int colIndex) {
        this.columns.remove(colIndex);
        for (int i = 0; i < this.getRowsCount(); ++i) {
            ((AbstractPWGridRow)this.getRow(i)).getCells().remove(colIndex);
        }
    }

    public int getColumnCount() {
        return this.columns.size();
    }

    public C getColumn(int colIndex) {
        return (C)((AbstractPWGridColumn)this.columns.get(colIndex));
    }

    public List<T> getOutputRows() {
        return this.outputRows;
    }

    public T getOutputRow(int idx) {
        return (T)((AbstractPWGridRow)this.getOutputRows().get(idx));
    }

    public List<C> getOutputColumns() {
        return this.outputColumns;
    }

    public C getOutputColumn(int colIndex) {
        return (C)((AbstractPWGridColumn)this.outputColumns.get(colIndex));
    }

    public boolean isNotBlankRow() {
        return this.notBlankRow;
    }

    public void setNotBlankRow(boolean notBlankRow) {
        this.notBlankRow = notBlankRow;
    }

    public String getGridBorderType() {
        return this.gridBorderType;
    }

    public void setGridBorderType(String gridBorderType) {
        this.gridBorderType = gridBorderType;
    }

    public void outputRow(T row) {
        this.getOutputRows().add(row);
    }

    @Override
    public IPrintWidget copy() {
        ITableTailSupport support;
        PWTableTail tableTail;
        AbstractPWGrid outputGrid = (AbstractPWGrid)super.copy();
        outputGrid.setStyle(null);
        outputGrid.rows = this.rows;
        outputGrid.columns = this.columns;
        outputGrid.setPrintAtPage(this.getPrintAtPage());
        outputGrid.columnsOutput();
        outputGrid.setNotBlankRow(this.isNotBlankRow());
        if (this.getMergeBlocks() != null) {
            for (Map.Entry<String, MergeBlock> entry : this.getMergeBlocks().entrySet()) {
                outputGrid.getMergeBlocks().put(entry.getKey(), (MergeBlock)entry.getValue().clone());
            }
        }
        if (this instanceof ITableTailSupport && (tableTail = (support = (ITableTailSupport)((Object)this)).getTableTail()) != null && tableTail.getPrintAtPage() == PrintAtPage.FlowAll) {
            ((ITableTailSupport)((Object)outputGrid)).setTableTail(tableTail.copy());
        }
        outputGrid.setStyle(this.getStyle());
        return outputGrid;
    }

    public void deepCopyRows(AbstractPWGrid grid) {
        if (this.rows != null && grid != null) {
            ArrayList<AbstractPWGridRow> rowsCopy = new ArrayList<AbstractPWGridRow>(this.rows.size());
            for (AbstractPWGridRow row : this.rows) {
                if (row == null) continue;
                AbstractPWGridRow rowCopy = (AbstractPWGridRow)row.deepCopy();
                rowsCopy.add(rowCopy);
            }
            grid.rows = rowsCopy;
        }
    }

    public void columnsOutput() {
        if (this.outputColumns != null && this.outputColumns.size() == this.columns.size()) {
            return;
        }
        this.outputColumns = new ArrayList(this.columns.size());
        int c = this.columns.size();
        for (int i = 0; i < c; ++i) {
            this.outputColumns.add((AbstractPWGridColumn)((AbstractPWGridColumn)this.columns.get(i)).copy());
        }
    }

    @Override
    public GridExecuteContext getContext() {
        return this.getGridExecuteContext();
    }

    private GridExecuteContext getGridExecuteContext() {
        if (this._executeContext == null) {
            this._executeContext = new GridExecuteContext();
        }
        return (GridExecuteContext)this._executeContext;
    }

    public Map<String, MergeBlock> getMergeBlocks() {
        if (this.mergeBlocks == null) {
            this.mergeBlocks = new HashMap<String, MergeBlock>();
        }
        return this.mergeBlocks;
    }

    public int getRowCursor() {
        return this.getContext().getRowCursor();
    }

    public void addRowCursor() {
        if (this.wholeRowPage || this.tempWholeRowPage) {
            if (!this.getContext().isRowPagination()) {
                this.getContext().setRowCursor(this.getRowCursor() + 1);
            } else {
                this.tempWholeRowPage = false;
            }
        } else {
            this.getContext().setRowCursor(this.getRowCursor() + 1);
        }
    }

    public int getCurrentRowType() {
        AbstractPWGridRow currentRow = this.getCurrentRow();
        if (currentRow == null) {
            return 0;
        }
        return currentRow.getRowType();
    }

    public AbstractPWGridRow getCurrentRow() {
        int rowCursor = this.getRowCursor();
        if (rowCursor < 0 || rowCursor >= this.rows.size()) {
            return null;
        }
        return (AbstractPWGridRow)this.rows.get(rowCursor);
    }

    public void setRowCursor(int cursorIndex) {
        this.getContext().setRowCursor(cursorIndex);
    }

    public boolean isWholeRowPage() {
        return this.wholeRowPage || this.tempWholeRowPage;
    }

    public void setWholeRowPage(boolean wholeRowPage) {
        this.wholeRowPage = wholeRowPage;
    }

    public boolean isWholeGridPage() {
        return this.wholeGridPage;
    }

    public void setWholeGridPage(boolean wholeGridPage) {
        this.wholeGridPage = wholeGridPage;
    }

    public boolean isTempWholeRowPage() {
        return this.tempWholeRowPage;
    }

    public void setTempWholeRowPage(boolean tempWholeRowPage) {
        this.tempWholeRowPage = tempWholeRowPage;
    }

    public boolean isSkipTitleEvery() {
        return this.skipTitleEvery;
    }

    public void setSkipTitleEvery(boolean skipTitleEvery) {
        this.skipTitleEvery = skipTitleEvery;
    }
}

