/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.model.widget.grid;

import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import kd.bos.print.core.data.field.Field;
import kd.bos.print.core.data.field.ImageField;
import kd.bos.print.core.model.designer.grid.MergeBlock;
import kd.bos.print.core.model.widget.IPrintWidget;
import kd.bos.print.core.model.widget.IPrintWidgetContainer;
import kd.bos.print.core.model.widget.PWPicture;
import kd.bos.print.core.model.widget.PWText;
import kd.bos.print.core.model.widget.grid.MergeType;
import kd.bos.print.core.model.widget.grid.datagrid.cellvalue.ACellValue;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public abstract class AbstractPWGridCell
extends PWText
implements IPrintWidgetContainer {
    private transient ACellValue cellValue;
    private ArrayList<IPrintWidget> children;
    private MergeType mergeType = MergeType.None;
    private MergeBlock mergeBlock;
    private boolean isSubCell = false;
    private String oriOutPutText = "";
    private boolean mergeSummary;
    private boolean mergeBy;
    private int rowIndex;

    public boolean isMergeBy() {
        return this.mergeBy;
    }

    public void setMergeBy(boolean mergeBy) {
        this.mergeBy = mergeBy;
    }

    public boolean isMergeSummary() {
        return this.mergeSummary;
    }

    public void setMergeSummary(boolean mergeSummary) {
        this.mergeSummary = mergeSummary;
    }

    public String getOriOutPutText() {
        return this.oriOutPutText;
    }

    public void setOriOutPutText(String oriOutPutText) {
        this.oriOutPutText = oriOutPutText;
    }

    public void setCellValue(ACellValue cellValue) {
        this.cellValue = cellValue;
    }

    public ACellValue getCellValue() {
        return this.cellValue;
    }

    public boolean isMergedCell() {
        return this.mergeType != MergeType.None;
    }

    public MergeType getMergeType() {
        return this.mergeType;
    }

    public void setMergeType(MergeType mergeType) {
        this.mergeType = mergeType;
    }

    public MergeBlock getMergeBlock() {
        return this.mergeBlock;
    }

    public void setMergeBlock(MergeBlock mergeBlock) {
        this.mergeBlock = mergeBlock;
    }

    @Override
    public void addChild(IPrintWidget w) {
        this.getChildren().add(w);
    }

    @Override
    public List<IPrintWidget> getChildren() {
        if (this.children == null) {
            this.children = new ArrayList();
        }
        return this.children;
    }

    @Override
    public boolean hasChildren() {
        return this.children != null && this.children.size() != 0;
    }

    @Override
    public IPrintWidget copy() {
        AbstractPWGridCell cell = (AbstractPWGridCell)super.copy();
        cell.setMergeSummary(this.mergeSummary);
        cell.setOriOutPutText(this.oriOutPutText);
        cell.setRowIndex(this.getRowIndex());
        cell.mergeType = this.getMergeType();
        cell.setMergeBlock(this.getMergeBlock());
        cell.setCellValue(this.getCellValue());
        cell.setLineWrapRule(this.getLineWrapRule());
        cell.setFlexOffset(this.getFlexOffset());
        cell.setWordFlex(this.isWordFlex());
        cell.setAnchor(this.isAnchor());
        cell.setLinkUrl(this.getLinkUrl());
        cell.setLinkDs(this.getLinkDs());
        cell.setLinkDsType(this.getLinkDsType());
        cell.setLinkField(this.getLinkFiled());
        List<IPrintWidget> children = this.getChildren();
        for (IPrintWidget child : children) {
            cell.addChild(child);
        }
        cell.setMergeBy(this.mergeBy);
        return cell;
    }

    public IPrintWidget deepCopy() {
        AbstractPWGridCell cellCopy = (AbstractPWGridCell)this.copy();
        ArrayList<IPrintWidget> childrenCopy = new ArrayList<IPrintWidget>(this.getChildren().size());
        for (IPrintWidget child : this.getChildren()) {
            childrenCopy.add(child.copy());
        }
        cellCopy.children = childrenCopy;
        return cellCopy;
    }

    public void adjustHeight(int height) {
        Rectangle rectangle = this.getRectangle();
        rectangle.setRect(rectangle.getX(), rectangle.getY(), rectangle.getWidth(), height);
        List<IPrintWidget> children = this.getChildren();
        for (IPrintWidget widget : children) {
            PWPicture pwPicture;
            Field outputValue;
            if (!(widget instanceof PWPicture) || !((outputValue = (pwPicture = (PWPicture)widget).getOutputValue()) instanceof ImageField) || !pwPicture.isAdjustHeight()) continue;
            pwPicture.setRectangle(new Rectangle(0, 0, rectangle.width, height));
        }
    }

    public boolean isSubCell() {
        return this.isSubCell;
    }

    public void setSubCell(boolean subCell) {
        this.isSubCell = subCell;
    }

    public int getRowIndex() {
        return this.rowIndex;
    }

    public void setRowIndex(int rowIndex) {
        this.rowIndex = rowIndex;
    }
}

