/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.model.widget.grid;

import java.util.ArrayList;
import kd.bos.print.core.exception.PrintException;
import kd.bos.print.core.execute.ExecuteContext;
import kd.bos.print.core.model.widget.AbstractPrintWidget;
import kd.bos.print.core.model.widget.IPrintWidget;
import kd.bos.print.core.model.widget.grid.AbstractPWGridCell;

public abstract class AbstractPWGridRow<T extends AbstractPWGridCell>
extends AbstractPrintWidget {
    public static final int ROW_TITLE = 1;
    public static final int ROW_DETAIL = 2;
    public static final int ROW_STAT = 3;
    public static final int ROW_GROUP = 4;
    public static final int ROW_EXTEND = 5;
    private ArrayList<T> _cells;
    private int height;
    private boolean isAdjustHeight;
    private boolean isRemainContent;
    private int reaminHeight;
    private boolean isSubRow;
    private boolean isAddRow;
    private boolean isBlankRow;
    private int rowIndex;

    public AbstractPWGridRow() {
        this(0);
    }

    public AbstractPWGridRow(int size) {
        this._cells = new ArrayList(size);
        for (int i = 0; i < size; ++i) {
            this.addCell();
        }
    }

    public void setContext(ExecuteContext context) {
        this._executeContext = context;
    }

    public void setHeight(int h) {
        this.height = h;
    }

    public int getHeight() {
        return this.height;
    }

    public void setRemainContent(boolean isRemain) {
        this.isRemainContent = isRemain;
    }

    public boolean isRemainContent() {
        return this.isRemainContent;
    }

    public int getReaminHeight() {
        return this.reaminHeight;
    }

    public void setReaminHeight(int reaminHeight) {
        this.reaminHeight = reaminHeight;
    }

    public boolean isAdjustHeight() {
        return this.isAdjustHeight;
    }

    public void setAdjustHeight(boolean adjustHeight) {
        this.isAdjustHeight = adjustHeight;
    }

    protected abstract T addCell();

    protected abstract T insertCell(int var1);

    public T addCell(T cell) {
        return this.addCell(this._cells.size(), cell);
    }

    protected final T addCell(int cellIndex, T cell) {
        if (cellIndex < 0 || cellIndex > this._cells.size()) {
            return null;
        }
        this._cells.add(cellIndex, cell);
        return cell;
    }

    public final T setCell(int cellIndex, T cell) {
        if (cellIndex < 0 || cellIndex > this._cells.size() - 1) {
            throw new PrintException("1", "setCell Error,cellIndex out of Range");
        }
        this._cells.set(cellIndex, cell);
        return cell;
    }

    public abstract int getRowType();

    public T getCell(int cellIndex) {
        if (cellIndex < 0 || cellIndex >= this._cells.size()) {
            return null;
        }
        try {
            return (T)((AbstractPWGridCell)this._cells.get(cellIndex));
        }
        catch (IndexOutOfBoundsException ex) {
            return null;
        }
    }

    ArrayList<T> getCells() {
        return this._cells;
    }

    public int getCellCount() {
        return this._cells.size();
    }

    @Override
    public IPrintWidget copy() {
        AbstractPWGridRow newRow = (AbstractPWGridRow)super.copy();
        newRow.setHeight(this.getHeight());
        newRow.setAdjustHeight(this.isAdjustHeight());
        newRow.setRowIndex(this.getRowIndex());
        newRow.setBlankRow(this.isBlankRow());
        return newRow;
    }

    public IPrintWidget deepCopy() {
        AbstractPWGridRow rowCopy = (AbstractPWGridRow)this.copy();
        ArrayList<AbstractPWGridCell> cellsCopy = new ArrayList<AbstractPWGridCell>(this.getCellCount());
        for (int i = 0; i < this.getCellCount(); ++i) {
            T cell = this.getCell(i);
            if (cell == null) continue;
            cellsCopy.add((AbstractPWGridCell)((AbstractPWGridCell)cell).deepCopy());
        }
        rowCopy._cells = cellsCopy;
        return rowCopy;
    }

    public boolean isSubRow() {
        return this.isSubRow;
    }

    public void setSubRow(boolean subRow) {
        this.isSubRow = subRow;
    }

    public boolean isAddRow() {
        return this.isAddRow;
    }

    public void setAddRow(boolean addRow) {
        this.isAddRow = addRow;
    }

    public boolean isBlankRow() {
        return this.isBlankRow;
    }

    public void setBlankRow(boolean blankRow) {
        this.isBlankRow = blankRow;
    }

    public int getRowIndex() {
        return this.rowIndex;
    }

    public void setRowIndex(int rowIndex) {
        this.rowIndex = rowIndex;
    }
}

