/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.model.widget.grid.datagrid;

import java.awt.Rectangle;
import java.util.List;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.print.core.exception.PrintException;
import kd.bos.print.core.model.IDatasourceSupport;
import kd.bos.print.core.model.widget.IPrintWidget;
import kd.bos.print.core.model.widget.grid.AbstractPWGrid;
import kd.bos.print.core.model.widget.grid.datagrid.AbstractPWDataGridRow;
import kd.bos.print.core.model.widget.grid.datagrid.PWDataGridColumn;
import kd.bos.print.core.model.widget.grid.datagrid.PWDetailRow;
import kd.bos.print.core.model.widget.grid.datagrid.PWExtendRow;
import kd.bos.print.core.model.widget.grid.datagrid.PWGroupRow;
import kd.bos.print.core.model.widget.grid.datagrid.PWNormalRow;
import kd.bos.print.core.model.widget.grid.datagrid.context.GridExecuteContext;
import kd.bos.print.core.model.widget.grid.tabletail.ITableTailSupport;
import kd.bos.print.core.model.widget.grid.tabletail.PWTableTail;

public class PWDataGrid
extends AbstractPWGrid<AbstractPWDataGridRow, PWDataGridColumn>
implements IDatasourceSupport,
ITableTailSupport {
    private static final Log log = LogFactory.getLog(PWDataGrid.class);
    public static final String ExtProp_SinkToBottom = "sinkToBottom";
    private String ds;
    private boolean fixedRowAtPage;
    private int fixedRowCount;
    private boolean titleRowEveryPage;
    private boolean statRowEveryPage;
    private List<PWDataGrid> subDataGrids;
    private PWTableTail tableTail;
    private String subGridDirection;
    private String subGridDs;
    private boolean isSubGridField = false;
    private boolean calculatedSub = false;
    private boolean statWithData;
    private boolean hideEmptyMove;

    @Override
    public AbstractPWDataGridRow addRow(int type) {
        return this.createRow(type, this.rows.size());
    }

    @Override
    public void delRow(int rowIndex) {
        AbstractPWDataGridRow gridRow = (AbstractPWDataGridRow)this.rows.get(rowIndex);
        if (gridRow instanceof PWDetailRow) {
            throw new PrintException("-1", "DataGridRow not support to deleted");
        }
        super.delRow(rowIndex);
    }

    @Override
    protected AbstractPWDataGridRow createRow(int type, int rowIndex) {
        AbstractPWDataGridRow row;
        if (type == 1 || type == 3) {
            row = new PWNormalRow(this.columns.size(), type);
        } else if (type == 2) {
            row = new PWDetailRow(this.columns.size());
        } else if (type == 5) {
            row = new PWExtendRow(this.columns.size());
        } else if (type == 4) {
            row = new PWGroupRow(this.columns.size());
        } else {
            throw new IllegalArgumentException("Type error.");
        }
        this.rows.add(rowIndex, row);
        this.resetRowIndex();
        return row;
    }

    @Override
    public PWDataGridColumn addColumn() {
        PWDataGridColumn col = new PWDataGridColumn();
        this.columns.add(col);
        int c = this.getRowsCount();
        for (int i = 0; i < c; ++i) {
            ((AbstractPWDataGridRow)this.getRow(i)).addCell();
        }
        return col;
    }

    @Override
    public PWDataGridColumn insertColumn(int columnIndex) {
        PWDataGridColumn col = new PWDataGridColumn();
        this.columns.add(columnIndex, col);
        int c = this.getRowsCount();
        for (int i = 0; i < c; ++i) {
            ((AbstractPWDataGridRow)this.getRow(i)).insertCell(columnIndex);
        }
        return col;
    }

    @Override
    public IPrintWidget copy() {
        PWDataGrid outputGrid = (PWDataGrid)super.copy();
        outputGrid.setDatasource(this.getDatasource());
        outputGrid.setFixedRowCount(this.getFixedRowCount());
        outputGrid.setFixedRowAtPage(this.isFixedRowAtPage());
        outputGrid.setTitleRowEveryPage(this.isTitleRowEveryPage());
        outputGrid.setNotBlankRow(this.isNotBlankRow());
        outputGrid.calculatedSub = this.calculatedSub;
        return outputGrid;
    }

    @Override
    public GridExecuteContext getContext() {
        return this.getGridExecuteContext();
    }

    private GridExecuteContext getGridExecuteContext() {
        if (this._executeContext == null) {
            this._executeContext = new GridExecuteContext();
        }
        return (GridExecuteContext)this._executeContext;
    }

    public boolean isFixedRowAtPage() {
        return this.fixedRowAtPage;
    }

    public void setFixedRowAtPage(boolean fixedRowAtPage) {
        this.fixedRowAtPage = fixedRowAtPage;
    }

    public int getFixedRowCount() {
        return this.fixedRowCount;
    }

    public void setFixedRowCount(int fixedRowCount) {
        this.fixedRowCount = fixedRowCount;
    }

    public boolean isTitleRowEveryPage() {
        return this.titleRowEveryPage;
    }

    public void setTitleRowEveryPage(boolean titleRowEveryPage) {
        this.titleRowEveryPage = titleRowEveryPage;
    }

    public boolean isStatRowEveryPage() {
        return this.statRowEveryPage;
    }

    public void setStatRowEveryPage(boolean statRowEveryPage) {
        this.statRowEveryPage = statRowEveryPage;
    }

    @Override
    public void setDatasource(String ds) {
        this.ds = ds;
    }

    @Override
    public String getDatasource() {
        return this.ds;
    }

    public List<PWDataGrid> getSubDataGrids() {
        return this.subDataGrids;
    }

    public void setSubDataGrids(List<PWDataGrid> subDataGrids) {
        this.subDataGrids = subDataGrids;
    }

    public String getSubGridDirection() {
        return this.subGridDirection;
    }

    public void setSubGridDirection(String subGridDirection) {
        this.subGridDirection = subGridDirection;
    }

    public boolean isSubGrid() {
        return this.isSubGridField;
    }

    public void setSubGrid(boolean isSubGrid) {
        this.isSubGridField = isSubGrid;
    }

    @Override
    public PWTableTail getTableTail() {
        return this.tableTail;
    }

    @Override
    public void setTableTail(PWTableTail tableTail) {
        this.tableTail = tableTail;
    }

    public boolean isStatWithData() {
        return this.statWithData;
    }

    public void setStatWithData(boolean statWithData) {
        this.statWithData = statWithData;
    }

    public boolean isHideEmptyMove() {
        return this.hideEmptyMove;
    }

    public void setHideEmptyMove(boolean hideEmptyMove) {
        this.hideEmptyMove = hideEmptyMove;
    }

    @Override
    public Rectangle getRectangle() {
        Rectangle rectangle = super.getRectangle();
        if (this.calculatedSub) {
            return rectangle;
        }
        List<PWDataGrid> subDataGrids = this.getSubDataGrids();
        if (!CollectionUtils.isEmpty(subDataGrids)) {
            this.calculatedSub = true;
            int width = rectangle.width;
            int height = rectangle.height;
            for (PWDataGrid subGrid : subDataGrids) {
                Rectangle subRectangle = subGrid.getRectangle();
                if (subRectangle.x == rectangle.x) {
                    height += subRectangle.height;
                    continue;
                }
                width += subRectangle.width;
                height = Math.max(subRectangle.height, height);
            }
            rectangle.setRect(rectangle.x, rectangle.y, width, height);
        }
        return rectangle;
    }

    public String getSubGridDs() {
        return this.subGridDs;
    }

    public void setSubGridDs(String subGridDs) {
        this.subGridDs = subGridDs;
    }
}

