/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.model.widget.runner;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import kd.bos.print.core.ExecuteContext;
import kd.bos.print.core.ctrl.common.util.StringUtil;
import kd.bos.print.core.ctrl.reportone.r1.print.engine.IWidgetExecuteHelper;
import kd.bos.print.core.data.PdIterator;
import kd.bos.print.core.data.R1PDataVisitor;
import kd.bos.print.core.data.datasource.DsType;
import kd.bos.print.core.data.field.CollectionField;
import kd.bos.print.core.data.field.DateTimeField;
import kd.bos.print.core.data.field.Field;
import kd.bos.print.core.data.field.TextField;
import kd.bos.print.core.model.widget.AbstractPrintWidget;
import kd.bos.print.core.model.widget.IPrintWidget;
import kd.bos.print.core.model.widget.IPrintWidgetContainer;
import kd.bos.print.core.model.widget.PrintAtPage;
import kd.bos.print.core.model.widget.runner.IRunner;
import kd.bos.print.core.model.widget.runner.RelativeContext;
import kd.bos.print.core.plugin.PrintPluginProxy;
import kd.bos.print.core.plugin.event.AfterOutputWidgetEvent;
import kd.bos.print.core.plugin.event.BeforeInitWidgetEvent;
import kd.bos.print.core.service.IFormulaService;
import kd.bos.service.InteTimeZone;
import kd.bos.util.StringUtils;

public abstract class AbstractRunner<T extends AbstractPrintWidget>
implements IRunner {
    protected IPrintWidget outputWidget;
    protected IWidgetExecuteHelper helper;
    protected RelativeContext relativeContext;

    protected T getOutputWidget() {
        return (T)((AbstractPrintWidget)this.outputWidget);
    }

    @Override
    public void beginOutput(AbstractPrintWidget outputWidget) {
        if (outputWidget.isCanvasWidget()) {
            this.fireBeforeInitWedget(outputWidget);
            this.getRelativeContext().recordPosition(outputWidget);
            PrintAtPage atPage = outputWidget.getPrintAtPage();
            if (atPage == PrintAtPage.Nature) {
                this.getRelativeContext().scanRelative(outputWidget);
            }
        }
    }

    protected void fireBeforeInitWedget(AbstractPrintWidget outputWidget) {
        PrintPluginProxy pluginProxy = ExecuteContext.get().getPluginProxy();
        if (pluginProxy != null) {
            BeforeInitWidgetEvent<AbstractPrintWidget> evt = new BeforeInitWidgetEvent<AbstractPrintWidget>(outputWidget);
            pluginProxy.fireBeforeInitWidgetEvent(evt);
        }
    }

    protected void beforeCacheOutput(AbstractPrintWidget outputWidget) {
        PrintPluginProxy pluginProxy = ExecuteContext.get().getPluginProxy();
        if (pluginProxy != null) {
            AfterOutputWidgetEvent<AbstractPrintWidget> evt = new AfterOutputWidgetEvent<AbstractPrintWidget>(outputWidget);
            pluginProxy.fireAfterOutputWidget(evt);
        }
    }

    @Override
    public void cacheOutput(AbstractPrintWidget outputWidget) {
        if (!outputWidget.isCanvasWidget()) {
            return;
        }
        PrintAtPage atPage = outputWidget.getPrintAtPage();
        if (atPage == PrintAtPage.Nature || atPage == PrintAtPage.First || atPage == PrintAtPage.FlowNature || atPage == PrintAtPage.FlowAll) {
            this.beforeCacheOutput(outputWidget);
            this.getRelativeContext().cacheOutPutWidget(outputWidget);
        } else {
            this.getRelativeContext().addWidget(atPage.getCode(), outputWidget);
        }
    }

    @Override
    public void endOutput(AbstractPrintWidget outputWidget) {
        if (outputWidget.isCanvasWidget()) {
            this.getRelativeContext().recordPosition(outputWidget);
        }
        this.outputWidget = null;
    }

    @Override
    public RelativeContext getRelativeContext() {
        return this.relativeContext;
    }

    @Override
    public void setRelativeContext(RelativeContext relativeContext) {
        this.relativeContext = relativeContext;
    }

    @Override
    public void setWidget(IPrintWidget outputWidget) {
        this.outputWidget = outputWidget;
    }

    @Override
    public void executeChildren(IPrintWidgetContainer container, List<IPrintWidget> children) {
    }

    @Override
    public IWidgetExecuteHelper getWidgetHelper() {
        return this.helper;
    }

    protected IWidgetExecuteHelper.IDataHelper getDataHelper(IWidgetExecuteHelper helper, String ds) {
        IWidgetExecuteHelper.IDataHelper dataHelper = helper.getDataHelper();
        return dataHelper;
    }

    public int getHeaderHeight() {
        return this.getRelativeContext().getHeaderHeight();
    }

    public void setHeaderHeight(int headerHeight) {
        this.getRelativeContext().setHeaderHeight(headerHeight);
    }

    public int getFooterHeight() {
        return this.getRelativeContext().getFooterHeight();
    }

    public void setFooterHeight(int footerHeight) {
        this.getRelativeContext().setFooterHeight(footerHeight);
    }

    protected boolean isNumeric(String num) {
        if (num == null || StringUtils.isEmpty((String)num)) {
            return false;
        }
        if (num.startsWith("-")) {
            num = num.replace("-", "");
        }
        num = num.trim();
        return StringUtils.isNumeric((String)num);
    }

    protected Object runFormula(IWidgetExecuteHelper helper, IPrintWidget widget, String target) {
        if (target != null && (target.startsWith("=") || target.startsWith("$"))) {
            Object result = helper.runFormula(widget, target.substring(1));
            if (result instanceof Date) {
                InteTimeZone sysTz = InteTimeZone.getSysTimeZone();
                return sysTz.format((Date)result);
            }
            return result;
        }
        return null;
    }

    public String getFormulaValue(List<Object> formulaData, AbstractPrintWidget output, IWidgetExecuteHelper helper) {
        ArrayList<Object> classify = new ArrayList<Object>();
        for (int i = 0; i < formulaData.size(); ++i) {
            Object object = formulaData.get(i);
            if (object instanceof Map) {
                Map mapObj = (Map)object;
                classify.add(object);
                String ds = (String)mapObj.get("dataSource");
                String bf = (String)mapObj.get("bindField");
                String tf = (String)mapObj.get("textFormat");
                String dt = (String)mapObj.get("dsType");
                String value = "value";
                if (StringUtil.equals(ds, "$DsKey=[System]")) {
                    if (output.getPrintAtPage() == PrintAtPage.All && !"=now()".equals(bf) && !"=getUserName()".equals(bf)) continue;
                    Object formulaResult = this.runFormula(helper, output, bf);
                    mapObj.put(value, new TextField(formulaResult == null ? "" : formulaResult.toString()).getValue());
                    continue;
                }
                if (DsType.ENTRY == DsType.from(dt) || DsType.SUBENTRY == DsType.from(dt) || DsType.REPORT_ENTRY == DsType.from(dt)) {
                    CollectionField collectionField = new CollectionField();
                    if (DsType.ENTRY == DsType.from(dt)) {
                        R1PDataVisitor dataVisitor = this.getDataHelper(helper, ds).getDataVisitor(ds);
                        if (dataVisitor != null && dataVisitor.getRowsCount() > 0) {
                            collectionField = dataVisitor.getCollectionField(ds, false);
                        }
                    } else {
                        collectionField = this.getDataHelper(helper, ds).getDataVisitor(ds).getCollectionField(ds, false);
                    }
                    PdIterator it = collectionField.iterator();
                    ArrayList<Field> l = new ArrayList<Field>(16);
                    while (it.hasNext()) {
                        Field fieldValue = it.getField(bf);
                        l.add(fieldValue);
                        if (fieldValue instanceof DateTimeField) {
                            boolean singleEntryRow = true;
                            ListIterator<Object> formulaIt = formulaData.listIterator(i);
                            while (formulaIt.hasPrevious()) {
                                Object prevFormula = formulaIt.previous();
                                if (!(prevFormula instanceof String) || !((String)prevFormula).contains("(")) continue;
                                if (!((String)prevFormula).contains("count")) break;
                                singleEntryRow = false;
                                break;
                            }
                            if (singleEntryRow) break;
                        }
                        if (i - 1 >= 0 && formulaData.get(i - 1) instanceof String && (((String)formulaData.get(i - 1)).contains("LEFT") || ((String)formulaData.get(i - 1)).contains("RIGHT") || ((String)formulaData.get(i - 1)).contains("SUBSTRING"))) break;
                        it.next();
                    }
                    mapObj.put(value, l);
                    continue;
                }
                Field fieldValue = this.getDataHelper(helper, ds).getFieldValue(ds, bf);
                mapObj.put(value, fieldValue);
                continue;
            }
            classify.add(object);
        }
        IFormulaService formulaService = ExecuteContext.get().getServiceProxy().getFormulaService();
        return formulaService.parseExp(classify);
    }

    protected String getFormat(String tplSetFormat, Field outputValue) {
        if (!StringUtil.equals(tplSetFormat, "-")) {
            return tplSetFormat;
        }
        String format = outputValue.getFormat();
        if (StringUtil.isEmptyString(format)) {
            return tplSetFormat;
        }
        return format;
    }
}

