/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.model.widget.runner;

import java.math.BigDecimal;
import java.math.BigInteger;
import kd.bos.entity.format.FormatFactory;
import kd.bos.entity.format.FormatObject;
import kd.bos.entity.format.FormatTypes;
import kd.bos.entity.format.NumberFormatObject;
import kd.bos.print.core.data.field.Field;
import kd.bos.print.core.data.field.NullField;
import kd.bos.print.core.model.widget.AbstractPrintWidget;
import kd.bos.print.core.model.widget.runner.AbstractRunner;
import kd.bos.util.StringUtils;

public abstract class AbstractTextRunner<T extends AbstractPrintWidget>
extends AbstractRunner<T> {
    protected Field formatOutputValue(Field outputValue) {
        if (outputValue == null) {
            return NullField.get();
        }
        Object value = outputValue.getValue();
        if (outputValue instanceof NullField || value == null || StringUtils.isBlank((String)value.toString())) {
            return NullField.get();
        }
        return outputValue;
    }

    protected String formatNumber(BigDecimal value, NumberFormatObject numberformatObj, boolean ignoreTailZero, int scale) {
        FormatObject formatObject = new FormatObject();
        if (scale == -1) {
            scale = value.scale();
        }
        numberformatObj.setMinimumFractionDigits(scale);
        formatObject.setNumberFormat(numberformatObj);
        String num = FormatFactory.get((FormatTypes)FormatTypes.Number).getFormat(formatObject).format(value);
        if (ignoreTailZero && num.contains(".")) {
            String suffix = "";
            if (num.endsWith(")")) {
                suffix = ")";
                num = num.substring(0, num.length() - 1);
            }
            num = num.replaceAll("0+?$", "");
            num = num.replaceAll("[.]$", "");
            num = num + suffix;
        }
        return num;
    }

    protected BigDecimal toBigDecimal(Object value) {
        BigDecimal ret = BigDecimal.ZERO;
        if (value instanceof BigDecimal) {
            ret = (BigDecimal)value;
        } else if (value instanceof String) {
            try {
                ret = new BigDecimal(((String)value).trim());
            }
            catch (Exception exception) {}
        } else if (value instanceof Integer) {
            ret = new BigDecimal((Integer)value);
        } else if (value instanceof BigInteger) {
            ret = new BigDecimal((BigInteger)value);
        } else if (value instanceof Long) {
            ret = new BigDecimal((Long)value);
        } else if (value instanceof Number) {
            ret = BigDecimal.valueOf(((Number)value).doubleValue());
        }
        return ret;
    }
}

