/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.model.widget.runner;

import com.lowagie.text.DocumentException;
import java.awt.Font;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.print.core.ctrl.kdf.util.style.StyleUtil;
import kd.bos.print.core.ctrl.reportone.r1.print.common.R1PrintInfo;
import kd.bos.print.core.html.page.RichTextUserAgent;
import kd.bos.print.core.model.widget.runner.PrintPDFTextStripper;
import kd.bos.print.core.model.widget.runner.util.RichTextFontUtils;
import kd.bos.print.core.model.widget.runner.util.RichTextUtil;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.text.TextPosition;
import org.xhtmlrenderer.pdf.ITextFontResolver;
import org.xhtmlrenderer.pdf.ITextOutputDevice;
import org.xhtmlrenderer.pdf.ITextRenderer;
import org.xhtmlrenderer.pdf.ITextUserAgent;

public class BuildRichTextBuilder {
    private static Log log = LogFactory.getLog(BuildRichTextBuilder.class);
    private Font richTextFont;
    private Integer firstPageHeight;
    private Integer headerHeight;
    private Integer richTextWitdh;
    private Integer footerHeight;
    private R1PrintInfo printInfo;
    private String htmlString;

    public BuildRichTextBuilder richTextFont(Font richTextFont) {
        this.richTextFont = richTextFont;
        return this;
    }

    public BuildRichTextBuilder richTextWitdh(Integer richTextWitdh) {
        this.richTextWitdh = richTextWitdh;
        return this;
    }

    public BuildRichTextBuilder headerHeight(Integer headerHeight) {
        this.headerHeight = headerHeight;
        return this;
    }

    public BuildRichTextBuilder footerHeight(Integer footerHeight) {
        this.footerHeight = footerHeight;
        return this;
    }

    public BuildRichTextBuilder firstPageHeight(Integer firstPageHeight) {
        this.firstPageHeight = firstPageHeight;
        return this;
    }

    public BuildRichTextBuilder pageSize(R1PrintInfo printInfo) {
        this.printInfo = printInfo;
        return this;
    }

    public BuildRichTextBuilder withString(String htmlString) {
        this.htmlString = htmlString;
        return this;
    }

    public Result build() {
        return new Result(this);
    }

    public static final class Result {
        private int richPageNum;
        private int lastPageHeight;
        private int footerHeight;
        private int headerHeight;
        private int bottom;
        private int secondStartY;
        private OutputStream htmlPDFos;
        private InputStream htmlPDFis;

        public int getHeaderHeight() {
            return this.headerHeight;
        }

        public void setHeaderHeight(int headerHeight) {
            this.headerHeight = headerHeight;
        }

        public int getFooterHeight() {
            return this.footerHeight;
        }

        public void setFooterHeight(int footerHeight) {
            this.footerHeight = footerHeight;
        }

        public int getBottom() {
            return this.bottom;
        }

        public void setBottom(int bottom) {
            this.bottom = bottom;
        }

        public int getSecondStartY() {
            return this.secondStartY;
        }

        public void setSecondStartY(int secondStartY) {
            this.secondStartY = secondStartY;
        }

        public OutputStream getHtmlPDFos() {
            return this.htmlPDFos;
        }

        public void setHtmlPDFos(OutputStream htmlPDFos) {
            this.htmlPDFos = htmlPDFos;
        }

        public InputStream getHtmlPDFis() {
            return this.htmlPDFis;
        }

        public void setHtmlPDFis(InputStream htmlPDFis) {
            this.htmlPDFis = htmlPDFis;
        }

        public Result(int richPageNum) {
            this.richPageNum = richPageNum;
        }

        public Result(BuildRichTextBuilder builder) {
            try {
                StringBuilder htmlStringBuilder = this.initHtmlString(builder);
                this.createPDF(htmlStringBuilder);
                this.parsePDF(builder);
            }
            catch (Exception ex) {
                this.setRichPageNum(0);
                log.warn((Throwable)ex);
            }
        }

        public ByteArrayInputStream parse(OutputStream out) {
            ByteArrayOutputStream baos = (ByteArrayOutputStream)out;
            ByteArrayInputStream swapStream = new ByteArrayInputStream(baos.toByteArray());
            return swapStream;
        }

        private void parsePDF(BuildRichTextBuilder builder) throws IOException {
            int footHeight;
            PDDocument document = PDDocument.load((InputStream)this.parse(this.htmlPDFos));
            int pages = document.getNumberOfPages();
            this.setRichPageNum(pages);
            PrintPDFTextStripper printPDFTextStripper = new PrintPDFTextStripper();
            TextPosition textPosition = this.getLastText(pages, printPDFTextStripper, document);
            Double lastH = StyleUtil.ptToLom(textPosition.getY()) + (double)builder.headerHeight.intValue();
            if (this.getRichPageNum() == 1) {
                int startY = builder.printInfo.getCustomHeight() - builder.printInfo.getMarginTop() - builder.printInfo.getMarginBottom() - builder.firstPageHeight - builder.footerHeight;
                lastH = StyleUtil.ptToLom(textPosition.getY());
                lastH = lastH + (double)startY;
            }
            if ((double)(footHeight = builder.printInfo.getCustomHeight() - builder.printInfo.getMarginBottom() - builder.printInfo.getMarginTop() - builder.footerHeight) < lastH) {
                lastH = footHeight;
            }
            this.setLastPageHeight(lastH.intValue());
        }

        private TextPosition getLastText(int pageNum, PrintPDFTextStripper printPDFTextStripper, PDDocument document) throws IOException {
            printPDFTextStripper.setStartPage(pageNum);
            printPDFTextStripper.setEndPage(pageNum);
            printPDFTextStripper.getText(document);
            List<List<TextPosition>> lists = printPDFTextStripper.getCharactersByArticle();
            List<TextPosition> textPositionList = lists.get(0);
            if (textPositionList.size() == 0) {
                this.setRichPageNum(pageNum - 1);
                printPDFTextStripper.setStartPage(pageNum - 1);
                printPDFTextStripper.setEndPage(pageNum - 1);
                printPDFTextStripper.getText(document);
                List<List<TextPosition>> list = printPDFTextStripper.getCharactersByArticle();
                List<TextPosition> nextTextPositionList = list.get(0);
                return nextTextPositionList.get(nextTextPositionList.size() - 1);
            }
            return textPositionList.get(textPositionList.size() - 1);
        }

        private void createPDF(StringBuilder htmlString) throws DocumentException, IOException {
            try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
                String[] fontPaths;
                float DEFAULT_DOTS_PER_POINT = 26.666666f;
                int DEFAULT_DOTS_PER_PIXEL = 20;
                ITextOutputDevice iTextOutputDevice = new ITextOutputDevice(DEFAULT_DOTS_PER_POINT);
                ITextRenderer renderer = new ITextRenderer(DEFAULT_DOTS_PER_POINT, DEFAULT_DOTS_PER_PIXEL, iTextOutputDevice, (ITextUserAgent)new RichTextUserAgent(iTextOutputDevice));
                renderer.setDocumentFromString(htmlString.toString());
                ITextFontResolver fontResolver = renderer.getFontResolver();
                for (String fontPath : fontPaths = RichTextUtil.getFontsList()) {
                    if (fontPath == null) continue;
                    fontResolver.addFont(fontPath, "Identity-H", false);
                }
                renderer.layout();
                renderer.createPDF((OutputStream)os);
                renderer.getListener();
                this.htmlPDFos = os;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public File byte2File(byte[] buf, String filePath, String fileName) {
            FilterOutputStream bos = null;
            FileOutputStream fos = null;
            File file = null;
            try {
                File dir = new File(filePath);
                if (!dir.exists() && dir.isDirectory()) {
                    dir.mkdirs();
                }
                file = new File(filePath + File.separator + fileName);
                fos = new FileOutputStream(file);
                bos = new BufferedOutputStream(fos);
                bos.write(buf);
            }
            catch (Exception e) {
                log.error((Throwable)e);
            }
            finally {
                if (bos != null) {
                    try {
                        bos.close();
                    }
                    catch (IOException e) {
                        log.error("buffered output stream close error", (Throwable)e);
                    }
                }
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (IOException e) {
                        log.error("file output stream close error", (Throwable)e);
                    }
                }
            }
            return file;
        }

        private void resetPageSize(R1PrintInfo r1PrintInfo, BuildRichTextBuilder builder) {
            r1PrintInfo.setMarginTop(builder.headerHeight + r1PrintInfo.getMarginTop());
            r1PrintInfo.setMarginBottom(builder.footerHeight + r1PrintInfo.getMarginBottom());
            r1PrintInfo.setMarginLeft(0);
            r1PrintInfo.setMarginTop(0);
            r1PrintInfo.setMarginBottom(0);
            r1PrintInfo.setMarginRight(0);
            int height = builder.printInfo.getCustomHeight() - builder.printInfo.getMarginTop() - builder.printInfo.getMarginBottom() - builder.footerHeight - builder.headerHeight;
            r1PrintInfo.setCustomPaper(builder.richTextWitdh, height);
        }

        private StringBuilder initHtmlString(BuildRichTextBuilder builder) throws InvocationTargetException, IllegalAccessException {
            ArrayList<String> srcList = new ArrayList();
            try {
                srcList = RichTextUtil.getSrcList(builder.htmlString);
            }
            catch (Exception ex) {
                log.error(ex.getMessage());
            }
            builder.htmlString = RichTextUtil.parseHtmlImgSrc(builder.htmlString, srcList);
            StringBuilder htmlStringBuilder = RichTextUtil.initPageHtmlString();
            builder.htmlString = RichTextFontUtils.htmlFontTransform(builder.htmlString, builder.richTextFont);
            this.setFooterHeight(builder.footerHeight);
            this.setHeaderHeight(builder.headerHeight);
            this.setBottom(builder.printInfo.getMarginBottom());
            R1PrintInfo pageSize = new R1PrintInfo();
            BeanUtils.copyProperties((Object)pageSize, (Object)builder.printInfo);
            this.resetPageSize(pageSize, builder);
            R1PrintInfo fisrtPageSize = new R1PrintInfo();
            BeanUtils.copyProperties((Object)fisrtPageSize, (Object)pageSize);
            fisrtPageSize.setCustomPaper(pageSize.getCustomWidth(), pageSize.getCustomHeight());
            if (builder.printInfo != null) {
                StringBuilder paperSzieString = RichTextUtil.getPageHtmlStringBuilder(pageSize, false);
                htmlStringBuilder.append("<head>\n").append("    <style>").append((CharSequence)paperSzieString);
                if (builder.firstPageHeight != null) {
                    R1PrintInfo fisrtPageSizeInfo = this.getFisrtPrintInfo(builder.firstPageHeight, fisrtPageSize);
                    StringBuilder fisrtPageSizeString = RichTextUtil.getPageHtmlStringBuilder(fisrtPageSizeInfo, true);
                    htmlStringBuilder.append((CharSequence)fisrtPageSizeString);
                }
                htmlStringBuilder.append("tr { page-break-inside: avoid;} ").append("p { page-break-inside: avoid;} ").append("    </style>\n").append("</head>").append("<body style=\"font-family:").append(builder.richTextFont.getFamily(Locale.ENGLISH)).append("\">");
            }
            htmlStringBuilder.append(builder.htmlString).append("<p>&#12288;</p>").append("</body>").append("</html>");
            return htmlStringBuilder;
        }

        private R1PrintInfo getFisrtPrintInfo(Integer height, R1PrintInfo r1PrintInfo) {
            r1PrintInfo.setMarginTop(0);
            r1PrintInfo.setPaperHeight(height);
            return r1PrintInfo;
        }

        public int getRichPageNum() {
            return this.richPageNum;
        }

        public void setRichPageNum(int richPageNum) {
            this.richPageNum = richPageNum;
        }

        public int getLastPageHeight() {
            return this.lastPageHeight;
        }

        public void setLastPageHeight(int lastPageHeight) {
            this.lastPageHeight = lastPageHeight;
        }
    }
}

